/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uDFB
 */

// forked from gaina's soundetest9 - TextVisualizer

package 
{
    import flash.display.StageAlign;
    import flash.display.StageDisplayState;
    import flash.display.StageScaleMode;
    import flash.display.Sprite;
    
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    
    import flash.text.AntiAliasType;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    import flash.utils.ByteArray;
    
    //import net.hires.debug.Stats;
    import com.bit101.components.PushButton;
    
    [SWF(width="465",height="465",backgroundColor=0x000000,frameRate=12)]
    public class Main extends Sprite
    {
        private var rot:Number = 0;
        private var snd:Sound;
        private var sndChannel:SoundChannel;
        private var LRarr:Array = [];
        private var FFTswitcher:Boolean = false;
        private var w:Number;
        private var h:Number;
        private var size:Number = 1;
        private var btn:PushButton;
        
        public function Main():void 
        {
            //addChild(new Stats());
            Wonderfl.capture_delay(3);
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            playSound("http://www.takasumi-nagai.com/soundfiles/sound005.mp3");
            
            stage.addEventListener(Event.RESIZE, ResizeEventHandler);
        }
        
        
        private function playSound(sndUrl:String):void
        {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10,true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            snd.addEventListener(Event.COMPLETE, onComp);
        }
        
        private function onComp(e:Event):void 
        {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            sndChannel=new SoundChannel();
            sndChannel = snd.play(0, 5, new SoundTransform(0.5, 0));
            
            LRarr = draw();
            
            btn = new PushButton(stage, 0, 0, "FULL SCREEN", FullScreenMode);
            btn.x = w - btn.width;
            btn.y = h - btn.height;
            
            addEventListener(Event.ENTER_FRAME, loop);
            //stage.addEventListener(MouseEvent.CLICK, FFTSwitch);
        }
        
        //private function FFTSwitch(e:MouseEvent):void 
        //{
            //if (FFTswitcher) { FFTswitcher = false } else { FFTswitcher = true; }
        //}
        
        private function loop(event:Event):void 
        {
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitcher, 0);
            
            for (var n:int = 0; n < 2; n++)
            {
                var txArray:Array = LRarr[n];
                for (var i:int = 0; i < 256; i++)
                {
                    var tx:TextField = new TextField();
                    var tf:TextFormat = new TextFormat();
                    
                    tx = txArray[i];
                    tx.autoSize = TextFieldAutoSize.LEFT;
                    tx .text = "";
                    var data:Number = bytes.readFloat();
                    var str:String = data.toFixed(5);
                    var pattern:RegExp =/[-.]/;
                    str = str.replace(pattern, "");
                    if (data < 0)
                    {
                        str = str.replace(pattern, "");
                        tf.color = 0xAAAAAA;
                        tx.defaultTextFormat = tf;
                        tx.text = str;
                    }
                    else
                    {
                        tf.color = 0xEEEEEE;
                        tx.defaultTextFormat = tf;
                        tx.text = str;
                    }
                    //tx.scaleX = tx.scaleY = 1 + data * 1.2 * size;
                    tx.scaleX = tx.scaleY = size;
                    tx.alpha += data;
                    if(data < 0.2)
                    {
                        tx.alpha += (0 - tx.alpha) / 5;
                    }
                }
            }
        }
        
        private function ResizeEventHandler(e:Event):void 
        {
            w = stage.stageWidth;
            h = stage.stageHeight;
            
            btn.x = w - btn.width;
            btn.y = h - btn.height;
            
            for (var n:int = 0; n < 2; n++)
            {
                var txArray:Array = LRarr[n];
                for (var i:int = 0; i < 256; i++)
                {
                    var tx:TextField = new TextField();
                    var tf:TextFormat = new TextFormat();
                    tx.autoSize = TextFieldAutoSize.LEFT;
                    
                    tx = txArray[i];
                    tx.x = w / 16  * Math.floor(i / 32) + w / 2 * n;
                    tx.y = h / 32 * (i % 32);
                    
                    size = w / 16 / tx.width;
                    
                    if (size < 1)
                    {
                        size = 1;
                    }
                }
            }
            
        }
        
        private function FullScreenMode(e:Event):void
        {
            if (stage.displayState == StageDisplayState.NORMAL)
            {
                stage.displayState = StageDisplayState.FULL_SCREEN;
                btn.label = "NORMAL";
            }
            else
            {
                stage.displayState = StageDisplayState.NORMAL;
                btn.label = "FULL SCREEN";
            }
        }
        
        private function draw():Array
        {
            var master_arr:Array = [];
            
            for (var n:int = 0; n < 2; n++)
            {
                var lr_arr:Array = [];
                for (var i:int = 0; i < 8; i++)
                {
                    for (var j:int = 0; j < 32; j++)
                    {
                        var tx:TextField = new TextField();
                        var tf:TextFormat = new TextFormat();
                        tx.antiAliasType = AntiAliasType.ADVANCED;
                        tf.color = 0xEEEEEE;
                        tf.size = 9;
                        tx.defaultTextFormat = tf;
                        tx.text = "0";
                    
                        tx.x = w / 16 * i + w / 2 * n;
                        tx.y = h / 32 * j;
                        addChild(tx);
                        lr_arr.push(tx);
                    }
                }
                master_arr.push(lr_arr);
            }
            return master_arr;
        }
        
    }
    
}