/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uDD3
 */

// forked from StyleCube's forked from: forked from: swirl (10000 particles)
// forked from fr34k's forked from: swirl (10000 particles)
// forked from k__'s swirl (10000 particles)
package {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;

	[SWF(frameRate="60")]
	public class Main extends Sprite {
		private var mapHN:uint = 30,mapVN:uint = 30, sh:uint, sw:uint;
		private var tr:Number = 0.95, tg:Number = 0.95, tb:Number = 0.95;
		private var mapW:Number,mapH:Number;
		private var mX:Number,mY:Number;
		private var map:Array;
		private var particles:Array;
		private var numParticles:uint = 10000;
		private var canvas:BitmapData;

		public function Main() {
			sw = stage.stageWidth;
			sh = stage.stageHeight;
			graphics.beginFill(0x161616);
			graphics.drawRect(0,0,sw,sh);
			graphics.endFill();
			canvas = new BitmapData(sw,sh,false,0x00ffffff);
			addChild(new Bitmap(canvas));
			var i:uint,j:uint;
			mapW = sw / mapHN;
			mapH = sw / mapVN;
			init();
			
  			cmf = new ColorMatrixFilter([tr,0,0,0,0,	0,tg,0,0,0,	0,0,tb,0,0,	0,0,0,0.9,0]);
  			temp = new BitmapData(sw,sh,false,0x00000000);
			addEventListener(Event.ENTER_FRAME, h_enterFrame);
			addEventListener(MouseEvent.CLICK, init); // あれ?
		}
		
		private function init(e : MouseEvent = null) : void
		{
			var i : int, j : int;
			map = [];
			var m:Object;
			for (j = 0; j < mapVN; j ++) {
				map.push([]);
				for (i = 0; i < mapHN; i ++) {
					map[j].push(m = new Object);
					
					m.vx = Math.random() * 10- 5;
					m.vy = Math.random() * 10 - 5;
				}
			}
			
			var p:Particle;
			particles = [];
			for (i = 0; i < numParticles; i ++) {
				particles.push(p = new Particle(sw, sh));
			}
		}
		
		private var temp : BitmapData;

		private function h_enterFrame(evt:Event):void {
			var i:uint,j:uint,k:int,l:int,cnt:uint,tvx:Number,tvy:Number;
			var p:Particle,m:Object;
			temp.fillRect(temp.rect, 0x00000000);
			for (i = 0; i < numParticles; i ++) {
				p = particles[i];
				m = map[Math.floor(p.x / mapW)][Math.floor(p.y / mapH)];
				p.vx = (p.vx +(m.vx  - p.vx) / 10) * 0.99;
				p.vy = (p.vy + (m.vy  - p.vy) / 10) * 0.99;
				p.x += p.vx;
				p.y+= p.vy;
				if (p.x < 0 || p.y < 0 || p.x >= sw || p.y >= sw || Math.random() < 0.01) {
					p.init();
				}
				temp.setPixel(p.x, p.y, 0xffffff);
			}
			
			for (j = 0; j < mapVN; j ++) {
				for (i = 0; i < mapHN; i ++) {
					cnt  = 30;
					tvx = map[i][j].vx * cnt;
					tvy = map[i][j].vy * cnt;
					for (k = -2; k <=2; k ++) {
						if (i + k < 0 || i + k >= map.length) { continue }
						for (l = -2; l <= 2; l ++) {
							if (j + l < 0 || j + l >= map[i + k].length) { continue }
								tvx += map[i + k][j + l].vx;
								tvy += map[i + k][j + l].vy;
								cnt ++;
						}
					}
					map[i][j].vx = tvx / cnt;
					map[i][j].vy = tvy / cnt;
				}
			}
			
			if (mX || mY) {
				m = map[Math.floor(mX / mapW)][Math.floor(mY / mapH)];
				m.vx = (m.vx +(mouseX - mX) * 5) * 0.99;
				m.vy = (m.vy + (mouseY - mY) * 5) * 0.99;
			}
			mX = Math.max(0,Math.min(mouseX, sw - 1));
			mY = Math.max(0,Math.min(mouseY, sh - 1));
			
			if (Math.random() < 0.05) {
				tr = Math.random() / 5 + 0.8;
				tg = Math.random() / 5 + 0.8;
				tb = Math.random() / 5 + 0.8;
    			cmf = new ColorMatrixFilter([tr,0,0,0,0,	0,tg,0,0,0,	0,0,tb,0,0,	0,0,0,0.9,0]);
			}
			if(cmf)canvas.applyFilter(canvas,temp.rect,new Point(),cmf);
			
			canvas.applyFilter(canvas,temp.rect,new Point(),blur);
			
				
			canvas.draw(temp, new Matrix(), new ColorTransform(1,1,1,0.5,0,0,0,0),BlendMode.ADD);
		}
		
		private var cmf : ColorMatrixFilter;
		private var blur : BlurFilter = new BlurFilter(4, 4);
	}
}

class Particle {
	public var x:Number,y:Number, vx:Number, vy:Number, sw:uint, sh:uint;
	function Particle(w:uint, h:uint) {
		sw = w;
		sh = h;
		
		init();
	}
	public function init():void {
		x = Math.random() * sw;
		y = Math.random() * sh;
                vx = vy = 0;
		
	}
}
	