/**
 * Copyright JohnBrookes ( http://wonderfl.net/user/JohnBrookes )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uD93
 */

package
{
	import flash.events.Event;
	import org.papervision3d.core.math.Matrix3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	
	public class PVpivotTest extends BasicView
	{
		private var p:Plane;
		private var bb:Object;
		public function PVpivotTest():void
		{
			init();
			singleRender();
			addEventListener(Event.ENTER_FRAME, tick);
		}
		
		private function init():void
		{
			var material:ColorMaterial= new ColorMaterial(0x0000ff)
			material.doubleSided = true;
			
			p = new Plane(material);
			scene.addChild(p);
			
			bb = p.boundingBox();
			//trace(bb.min.x); //left edge
		}
		
		private function tick(e:Event):void 
		{
			// this rotates the plane about its left edge
			//rotationMatrixWithReference(axis:Number3D, rad:Number, ref:Number3D)
			p.geometry.transformVertices(Matrix3D.multiply(Matrix3D.rotationMatrixWithReference(new Number3D(0,1,0), (1*Math.PI/180), new Number3D(bb.min.x,0,0)), new Matrix3D())); 
			singleRender();
		}
	}
}