/**
 * Copyright hacker_quje8j4f ( http://wonderfl.net/user/hacker_quje8j4f )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uCTO
 */

// forked from nulldesign's UnyoUnyo
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;
    import flash.geom.*;
    import flash.filters.GlowFilter;
    
    /*
        lineToで書いてみました。@nulldesign
    */
    
    [SWF(width="465", height="465", backgroundColor="0x000000") ]
    
    public class UnyoUnyo extends Sprite
    {
        //全体のうにょにょの数
        private const AllNums:uint = 512;
        
        //うにょうにょの関節の数
        private const SECTION:uint = 6;
        
        //うにょうにょブッコミ配列
        private var sectionList:Array = [];
        
        //おなじみのアレ
        private var _forceField:BitmapData;
        private var _randomSeed:uint = Math.floor( Math.random() * 0xFFFF );
        private var _offset:Array = [ new Point(), new Point() ];
        
        public function UnyoUnyo():void
        {
            addEventListener( Event.ADDED_TO_STAGE, initialize );
        }
        private function initialize( e:Event ):void
        {
            removeEventListener( Event.ADDED_TO_STAGE, initialize );
            
            //全体にフィルターかける。重たかったらはずしてもよいかもしれませｎ
            var _filter:GlowFilter = new GlowFilter( 0x003399, 1, 12, 12, 2, 1, false, false );
            this.filters = [ _filter ];
            
            //力場の描画
            _forceField = new BitmapData( stage.stageWidth, stage.stageHeight );
            _forceField.perlinNoise( stage.stageWidth >> 4, stage.stageHeight >> 4, 2, _randomSeed, false, true, 7, false, _offset ); 
            
            //うにょうにょの生成
            var _w:Number = stage.stageWidth;
            var _h:Number = stage.stageHeight ;
            for( var z:uint = 0; z < AllNums; z++ )
            {
                var _px:Number = Math.random() * _w;
                var _py:Number = Math.random() * _h;
                var _list:Array = [];
                for( var i:uint = 0; i < SECTION; i++ )
                {
                    var _sec:SectionData = new SectionData( _px, _py );
                    _list.push( _sec );
                }
                sectionList.push( _list );
            }
            
            //動きます
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function loop( e:Event ):void
        {
            var _w:Number = stage.stageWidth;
            var _h:Number = stage.stageHeight;
            var delayVal:Number = .5;
            
            //画面を一度きれいにしてから描画
            this.graphics.clear();
            
            var r:Number;
            var g:Number;
            var b:Number;
            
            for( var z:uint = 0; z < AllNums; z++ )
            {
                var _list:Array = sectionList[z];
            
                var _sec:SectionData = _list[0] as SectionData;
                var _secP:SectionData;
                
                var _color:Number = _forceField.getPixel( _sec.x, _sec.y );
                r = ( ( _color >> 16 ) & 0xFF ) - 128;
                g = ( ( _color >> 8 ) & 0xFF ) - 128;
                b = ( _color & 0xFF ) - 128;
                
                r *= .08;
                g *= .08;
                b*= .08;
                
                _sec.vx += r * delayVal;
                _sec.vy += g * delayVal;
                
                _sec.vx *= .98;
                _sec.vy *= .98;
                
                _sec.x += _sec.vx;
                _sec.y += _sec.vy;
                
                //座標関係の調整
                if( _sec.x <= 0 )
                {
                    _sec.x = 0;
                    _sec.vx *= -.96;
                };
                if( _sec.x > _w )
                {
                    _sec.x = _w;
                    _sec.vx *= -.96;
                };
                if( _sec.y <= 0 )
                {
                    _sec.y = 0;
                    _sec.vy *= -.96;
                };
                if( _sec.y > _h )
                {
                    _sec.y = _h;
                    _sec.vy *= -.96;
                };
                
                
                //うにょうにょの頭だけ力場で動かして、後ろからついてくるボディ（？）は頭についていくイメージです。
                this.graphics.moveTo( _sec.x, _sec.y );
                this.graphics.lineStyle( 12, 0xFFFFFF );
                for( var i:uint = 1; i < SECTION; i++ )
                {
                    _sec = _list[i] as SectionData;
                    _secP = _list[i-1] as SectionData;
                    _sec.x += ( _secP.x - _sec.x ) * delayVal;
                    _sec.y += ( _secP.y - _sec.y ) * delayVal;
                    
                }
                
                //描画
                for( i = 0; i < SECTION; i++ )
                {
                    _sec = _list[i] as SectionData;
                    this.graphics.lineStyle( ( SECTION - i ) * .75, 0xFFFFFF );
                    this.graphics.lineTo( _sec.x, _sec.y );
                }
            }
        }
    }
}

class SectionData
{
    public var x:Number;
    public var y:Number;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    
    public function SectionData( _x:Number = 0, _y:Number = 0 ):void
    {
        this.x = _x;
        this.y = _y;
    }
}