/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uCFY
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author Greek Fellows
     */
    public class Blossomcrack extends Sprite 
    {
        private var array:Array;
        private var others:Array;
        
        private var bitmapData:BitmapData;
        private var bitmap:Bitmap;
        
        private var sprite:Sprite;
        
        private const theme:Array = [0x2B3A42, 0x3F5765, 0xBDD4DE, 0xEFEFEF, 0xFF530D];
        
        public function Blossomcrack():void 
        {
            init();
        }
        
        private function init():void {
            this.array = [];
            this.others = [];
            
            this.bitmapData = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x000000);
            this.bitmap = new Bitmap(this.bitmapData);
            
            this.sprite = new Sprite();
            
            for (var cre:int = 0; cre < 5; cre++) {
                blossom(465/2, 465/2, 150);
            }
            
            this.addEventListener(Event.ENTER_FRAME, blossomcrack);
        }
        
        private function blossomcrack(e:Event):void {
            sprite.graphics.clear();
            
            for (var a:int = 0; a < this.array.length; a++) {
                sprite.graphics.lineStyle(1, this.others[a].color, .1);
                
                if (this.array[a].main) {
                    sprite.graphics.moveTo(this.array[a].cx, this.array[a].cy);
                    sprite.graphics.lineTo(this.array[a].x, this.array[a].y);
                } else {
                    sprite.graphics.moveTo(this.array[this.array[a].pi].x, this.array[this.array[a].pi].y);
                    sprite.graphics.lineTo(this.array[a].x, this.array[a].y);
                }
            }
            
            this.bitmapData.draw(this.sprite);
            this.removeChildren();
            this.addChild(this.bitmap);
            
            if (this.array.length < 500) {
                if (Math.floor(Math.random() * 100) == 0) {
                    blossom();
                }
            }
            
            for (var b:int = 0; b < this.array.length; b++) {
                this.array[b].rot += this.others[b].speed / 5;
                
                if (this.array[b].main) {
                    this.array[b].x = this.array[b].cx + Math.cos(this.array[b].rot * Math.PI / 180) * this.array[b].length;
                    this.array[b].y = this.array[b].cy + Math.sin(this.array[b].rot * Math.PI / 180) * this.array[b].length;
                } else {
                    this.array[b].x = this.array[this.array[b].pi].x + Math.cos(this.array[b].rot * Math.PI / 180) * this.array[b].length;
                    this.array[b].y = this.array[this.array[b].pi].y + Math.sin(this.array[b].rot * Math.PI / 180) * this.array[b].length;
                }
            }
        }
        
        private function blossom(x:Number = 465/2, y:Number = 465/2, initBranchLength:Number = 10):void {
            var r:Number = Math.floor(Math.random() * 360);
            
            if (this.array.length > 0) {
                var pi:int = Math.floor(Math.random() * this.array.length);
                this.array.push( { x:this.array[pi].x + Math.cos(r * Math.PI / 180) * this.array[pi].length * .85, y:this.array[pi].y + Math.sin(r * Math.PI / 180) * this.array[pi].length * .75, rot:r, length:this.array[pi].length * .75, pi:pi } );
            } else {
                this.array.push( { cx:x, cy:y, x:x + Math.cos(r * Math.PI / 180) * initBranchLength, y:y + Math.sin(r * Math.PI / 180) * initBranchLength, rot:r, length:initBranchLength, main:true } );
            }
            
            this.others.push( { color:this.theme[Math.floor(Math.random() * this.theme.length)], speed:Math.floor(Math.random() * 10) - 5 } );
        }
        
    }
    
}