/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uBdQ
 */

package {
	import flash.display.Sprite;
	import flash.system.Security;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.events.Event;
	import flash.text.TextField;
	import flash.display.Loader;
	public class FlashTest extends Sprite {
		private static const MAX:int = 30;
		private const MX:Number = stage.stageWidth / 2;
		private const MY:Number = stage.stageHeight / 2;
		private const R:Number = Math.min(MX, MY) - 50;
		private var map:Object = {};
		private var fringe:Vector.<String> = new Vector.<String>();
		private var web:Vector.<Vector.<String>> = new Vector.<Vector.<String>>(MAX, true);
		private var count:int = 0;
		private var t:TextField = new TextField();
		public function FlashTest() {
			t.width = stage.stageWidth;
			t.height = stage.stageHeight;
			addChild(t);
			Security.loadPolicyFile('http://5ivestar.org/proxy/crossdomain.xml');
			fringe.push(escape(loaderInfo.parameters['viewer.displayName']));
			propagate();
		}
		private function propagate():void {
			if (count >= MAX || !fringe.length) {
				drawConnections();
				return;
			}
			var name:String = fringe.shift();
			t.text = fringe.join('\n');
			map[name] = count;
			web[count] = new Vector.<String>();
			var profile:URLLoader = new URLLoader(new URLRequest('http://5ivestar.org/proxy/http://wonderfl.net/user/' + name));
			profile.addEventListener(Event.COMPLETE, propagate2);
		}
		private function propagate2(v:Event):void {
			var d:String = v.target.data;
			var s:int, e:int, f:int;
			s = d.indexOf('<div class="user_img">');
			s = d.indexOf('<img src="', s) + 10;
			e = d.indexOf('" alt="', s);
			var img:Loader = new Loader();
			img.load(new URLRequest('http://5ivestar.org/proxy/http://wonderfl.net' + d.substring(s, e)));
			img.x = MX + R * Math.cos(2 * Math.PI * count / MAX);
			img.y = MY + R * Math.sin(2 * Math.PI * count / MAX);
			img.scaleX = 0.4;
			img.scaleY = 0.4;
			img.rotation = 360. * count / MAX;
			addChild(img);
			e = d.indexOf('<div class="box" id="following_box">', e) + 36;
			if (e >= 36) {
				f = d.indexOf('<div class="box"', e);
				while (true) {
					s = d.indexOf('<a href="http://wonderfl.net/user/', e) + 34;
					if (s < 34 || s > f)
						break;
					e = d.indexOf('" title="', s);
					var c:String = d.substring(s, e);
					fringe.push(c);
					t.text = web[count].toString();
					web[count].push(c);
					e = d.indexOf('</span>', e);
				}
			}
			count++;
			propagate();
		}
		private function drawConnections():void {
			t.text = 'drawing connections';
			graphics.lineStyle(0, 0, 0.1);
			for (var i:int = 0; i < MAX; i++) {
				var out:Vector.<String> = web[i];
				for (var j:int = 0; j < out.length; j++) {
					if (!map.hasOwnProperty(out[j]))
						continue;
					var k:int = map[out[j]];
					graphics.moveTo(
						MX + R * Math.cos(2 * Math.PI * i / MAX),
						MY + R * Math.sin(2 * Math.PI * i / MAX)
					);
					graphics.lineTo(
						MX + R * Math.cos(2 * Math.PI * k / MAX),
						MY + R * Math.sin(2 * Math.PI * k / MAX)
					);
				}
			}
			removeChild(t);
			t = null;
		}
	}
}