/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uBZS
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.geom.Transform;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.utils.Timer;
    import net.hires.debug.Stats

    /**
     * ...
     * @author moriya
     */
    public class Main extends Sprite
    {
        private const STW:uint = stage.stageWidth, STH:uint = stage.stageHeight;
        private const FADE:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,-0x05);
        //[Embed(source = "../lib/busaneko.jpg")]private var Emb:Class;
        private var bmpData:BitmapData;
        private var bmpBuffer:BitmapData;
        //private var container:Sprite;
        private var render:Sprite;
        private var blurObj:Object;
        private var trgtSP:Sprite;
        private var img:Bitmap;
        private var _timer:Timer;
        private var max:int;
        private var cnt:int=0;
        private var _imgLoaderInfo:LoaderInfo;
        private var bmd:BitmapData;
        private var _imgLoader:Loader;

        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            var url:String = "http://assets.wonderfl.net/images/related_images/a/af/af90/af90356c6bcf822829d5f2787430a0c15332e42a";
            var urlReq:URLRequest = new URLRequest(url);
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            _imgLoader = new Loader();
            _imgLoaderInfo = _imgLoader.contentLoaderInfo;
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageloaded);
            _imgLoader.load(urlReq, context);
        }

        private function onImageloaded(e:Event):void
        {
            bmd =  new BitmapData(_imgLoader.width, _imgLoader.height);
            bmd.draw(_imgLoader);
            img = new Bitmap(bmd);

            trgtSP = new Sprite();
            trgtSP.addChild( new Bitmap(bmd.clone()) );

            //表示用
            render = new Sprite();
            render.x = (STW - img.width) * .5;
            render.y = (STH - img.height) * .5;
            addChild(render);
            render.addChild( new Bitmap(bmd.clone()));

            // ブラーの領域
            blurObj = { x:-render.x, y:-render.y, w:STW, h:STH, scale:1.06, alpha:0.1, centerX:img.width*.5, centerY:img.height*.5};

            bmpData = new BitmapData(blurObj.w, blurObj.h, true, 0x00FFFFFF);
            bmpBuffer = new BitmapData(blurObj.w, blurObj.h, true, 0x00FFFFFF);
            //_timer=new Timer(1,20);
            //_timer.addEventListener(TimerEvent.TIMER,fn_effect);
            //_timer.start();
            max = 10;
            addEventListener(Event.ENTER_FRAME,fn_effect)
            addEventListener(MouseEvent.CLICK, fnClick);

            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, STW, STH);
            graphics.endFill();

            addChild(new Stats());
        }

        private function fnClick(e:MouseEvent):void
        {
            render.graphics.clear();
            blurObj.scale =1
            //_timer.start();
            cnt=0

        }

        public function fn_effect(event:Event):void {
            if (cnt != max)
            {
                cnt++;
                fn_render(render);
            }

            bmpData.colorTransform(bmpData.rect, FADE);

        }

        private function fn_render(_render:Sprite):void
        {
            var trans:Transform = new Transform(_render);

            var color:ColorTransform = new ColorTransform(1, 1, 1, blurObj.alpha, 0, 0, 0, 0);
            trans.colorTransform = color;

            //バッファから描画用ビットマップに転送
            bmpData.copyPixels(bmpBuffer,new Rectangle(0, 0, blurObj.w, blurObj.h),new Point(0, 0));
            // バッファにキャプチャー
            var m:Matrix = new Matrix(1, 0, 0, 1, 0, 0);
            bmpBuffer.fillRect(new Rectangle(0, 0, blurObj.w, blurObj.h),0x00FFFFFF);
            bmpBuffer.draw(trgtSP,m);
            blurObj.scale += 0.09//Math.random()*.01;

            // 描画オフセット用行列
            var m2:Matrix = new Matrix(1, 0, 0, 1, 0, 0);
            m2.translate(-blurObj.centerX,-blurObj.centerY);
            m2.scale(blurObj.scale,blurObj.scale);
            m2.translate(blurObj.centerX,blurObj.centerY);

            // 上に重ねて描画
            var myBitmap:BitmapData = new BitmapData(trgtSP.width,trgtSP.height, false);
            myBitmap.draw(trgtSP, m2);

            //_render.graphics.clear();
            _render.graphics.beginBitmapFill(bmpData,m2);
            _render.graphics.moveTo(blurObj.x,blurObj.y);
            _render.graphics.lineTo(blurObj.x,blurObj.h);
            _render.graphics.lineTo(blurObj.w,blurObj.h);
            _render.graphics.lineTo(blurObj.w,blurObj.y);
            _render.graphics.endFill();
        }

    }

}

