/**
 * Copyright marmph ( http://wonderfl.net/user/marmph )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uBOi
 */

package {
    import flash.geom.Matrix;
    
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.system.Security;
    
    [SWF(backgroundColor="0x000000", frameRate="60")]
    
    /*
    FUN DANDY FRAME BLENDING!
    */
    
    public class FlashTest extends Sprite {
        
            private var canvas:Bitmap;
            private var canvasData:BitmapData;
            private var buffer:BitmapData;
            
            private var image:BitmapData;
                        
            private var alphaTransform:ColorTransform;
            
            private var particles:Array = [];
            
            private var highQuality:Boolean = true;
            
            private var up:Boolean = false;
            private var down:Boolean = false;
            private var left:Boolean = false;
            private var right:Boolean = false;
            
            private var lunch:Particle;
            
            private var loader:Loader;
        
        public function FlashTest() {
            
            canvasData = new BitmapData(465, 465, true, 0xff000000);
            buffer = new BitmapData(465, 465, true, 0xff000000);
            canvas = new Bitmap(canvasData);
            addChild(canvas);
            
            Security.loadPolicyFile("http://marmphco.com/crossdomain.xml");
            image = new BitmapData(100, 100, true, 0xffff);
            var request:URLRequest = new URLRequest("http://marmphco.com/imgs/void.gif");
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad, false, 0, true);
           // loader.load(request);
                       
            alphaTransform = new ColorTransform(1, 1, 1, .2, 0, 0, 0, 0)
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame, false, 0, true);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown, false, 0, true);
            stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp, false, 0, true);
            
            lunch = new Particle(0, 0, true);
            particles[200] = lunch;
            
            for(var i:int = 0; i < 199; i++) {
                    
                    var bob:Particle = new Particle(Math.random()*465, Math.random()*465);
                    particles[i] = bob;
                
            }
            
        }
        
        public function onLoad(e:Event):void {
            
            image.draw(loader);
            
        }

        
        public function onEnterFrame(e:Event):void {
            
                if(up) lunch.applyForce(Math.PI*3/2, 1);
                if(down) lunch.applyForce(Math.PI/2, 1);
                if(left) lunch.applyForce(Math.PI, 1);
                if(right) lunch.applyForce(0, 1);
            
            
                canvasData.lock();
                
                buffer.fillRect(buffer.rect, 0xff000000);
                              
                             
                            
                var p:Particle;
                for each(p in particles) {
                    
                    //canvasData.setPixel(int(p.x), int(p.y), 0xffffff);
                    buffer.fillRect(new Rectangle(p.x, p.y, p.w, p.h), p.color);
                    //buffer.copyPixels(image, image.rect, new Point(p.x, p.y));

                    p.update();
                    
                }
                if(highQuality) buffer.colorTransform(canvasData.rect, alphaTransform);
                canvasData.copyPixels(buffer, buffer.rect, new Point(0, 0), null, null, true);
                
                canvasData.unlock();
            
        }
        
        public function onKeyDown(e:KeyboardEvent):void {
                
                switch(e.keyCode) {
                    case 87:
                        up = true;
                        break;
                    case 65:
                        left = true;
                        break;
                    case 83:
                        down = true;
                        break;
                    case 68:
                        right = true;
                        break;
                    case 32: 
                        highQuality = !highQuality;
                        break;
                }
            
        }
        
        public function onKeyUp(e:KeyboardEvent):void {
            
                switch(e.keyCode) {
                    case 87:
                        up = false;
                        break;
                    case 65:
                        left = false;
                        break;
                    case 83:
                        down = false;
                        break;
                    case 68:
                        right = false;
                        break;    
                }
                
        }
        
    }
    
}

class Particle {
    
    private const DECAY:Number = 0.1;
    
    public var x:Number;
    public var y:Number;
    private var xv:Number = 0;
    private var yv:Number = 0;
    
    private var dir:Number;    
    
    //superficial
    public var color:Number;
    public var w:Number;
    public var h:Number;
    
    public function Particle(sx:Number, sy:Number, isSpecial:Boolean = false):void {
        
        x = sx;
        y = sy;
        dir = Math.round(Math.random())*Math.PI;
        color = Math.random()*0xffffff+0xff000000;
        w = Math.random()*20+10;
        h = w;//Math.random()*10+5;
        
        if(isSpecial) color = 0xffffffff;
        
        applyForce(Math.random()*Math.PI*2, Math.random()*5);
        
    }
    
    public function update():void {
        
        if(x > 465) {
                x = 465;
                xv *= -1;
            } else if(x < 0) {
                x = 0;
              xv *= -1;
            }        
            if(y > 465) {
                y = 465;
                yv *= -1;
            } else if(y < 0) {
                y = 0;
                yv *= -1;
            }
                
            if(x > 415) {
                dir = Math.PI;
            }
            if(x < 50) {
                dir = 0;
            }        
        if(color != 0xffffffff)    applyForce(dir, 1);
        
        x += xv -= xv*DECAY;
        y += yv -= yv*DECAY;
        
    }
    //more like acceleration
    public function applyForce(dir:Number, mag:Number):void {
        
        xv += Math.cos(dir)*mag;
        yv += Math.sin(dir)*mag;
        
    }
    
}