/**
 * Copyright theodoorjp ( http://wonderfl.net/user/theodoorjp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uBBY
 */

package {
    import flash.display.*;
	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import com.bit101.components.*;
	
	[SWF(backgroundColor="#eeeeee", frameRate=10)]
    public class DelayMic extends Sprite {
    	
    		// Delay
		private static const SAMPLE_RATE:Number = 44100;
		private var _micBuffer:Vector.<Number> = new Vector.<Number>();
		private var _delayBuffer:Vector.<Number> = new Vector.<Number>();
		private var _time:Number = 0.0; // 0.0 - 2.0
		private var _feedback:Number = 0.0; // 0.0 - 1.0
		private var _wet:Number = 0.0; // 0.0 - 1.0
		private var _head:Number = 0;
		private var _timeSlider:HSlider;
		private var _feedbackSlider:HSlider;
		private var _wetSlider:HSlider;
    	
        public function DelayMic() {
            	new Label(this, 10, 10, "time");
			_timeSlider = new HSlider(this, 10, 30, changeVal);
			new Label(this, 10, 50, "feedback");
			_feedbackSlider = new HSlider(this, 10, 70, changeVal);
			new Label(this, 10, 90, "wet");
			_wetSlider = new HSlider(this, 10, 110, changeVal);
			
			// default
			_timeSlider.value = 10;
			_feedbackSlider.value = 50;
			_wetSlider.value = 50;
			changeVal();
			
			initSound();
        }
        
		private function changeVal(e:Event = null):void {
			_time = _timeSlider.value / 100 * 2;
			_feedback = _feedbackSlider.value / 100;
			_wet = _wetSlider.value / 100;
		}
		
		private function initSound():void {
			// Max 2 seconds
			for (var i:Number = 0; i < SAMPLE_RATE * 2; i++) {
				_delayBuffer.push(0);
			}
			
			var sound:Sound = new Sound();
			sound.addEventListener(SampleDataEvent.SAMPLE_DATA, generateSound);
			sound.play();
			
			var mic:Microphone = Microphone.getMicrophone();
			mic.rate = 22;
			mic.setSilenceLevel(0);
			mic.setLoopBack(false);
			mic.addEventListener(SampleDataEvent.SAMPLE_DATA, getMicSound);
		}
		
		private function getMicSound(e:SampleDataEvent):void {
			while(e.data.bytesAvailable) {
				var sample:Number = e.data.readFloat();
				_micBuffer.push(sample);
			}
		}
		
		private function generateSound(e:SampleDataEvent):void {
			var smpl:Number = 0;
			for (var i:int = 0; i < 2048; i++) {
				if (i % 2 == 0) {
					smpl = _micBuffer.shift();
					if (isNaN(smpl)) smpl = 0;
				}
				var delSmpl:Number = delayEffect(smpl);
				e.data.writeFloat(delSmpl);
				e.data.writeFloat(delSmpl);
			}
		}
		
		public function delayEffect(val:Number):Number {
			
			if (_head >= _delayBuffer.length) _head = 0;
			
			var delayPos:Number = (_head - Math.floor(SAMPLE_RATE * _time) +  _delayBuffer.length) % _delayBuffer.length;
			var wetSmpl:Number = _delayBuffer[delayPos];
			_delayBuffer[_head] = wetSmpl * _feedback + val;
			var smpl:Number = val * (1 - _wet) + wetSmpl * _wet;
			_head++;
			
			return smpl;
		}
    }
}