/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uAzP
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;

    [SWF(width = "465", height = "465")]
    public class AppXOXO extends Sprite {
        private var vid : Video;
        private var vmtx : Matrix;
        private var bmd : BitmapData;
        private var vbmd : BitmapData;
        private var ofscr : BitmapData;
        private var shp : Vector.<Shape>;
        private var shpm : Matrix;
        private var shpr : Rectangle;
        private var cmap : Array = [];

        function AppXOXO() {
            /* canvas */

            stage.stageFocusRect = stage.mouseChildren = mouseEnabled = tabEnabled = tabChildren = false;
            stage.scaleMode = "noScale";
            stage.align = "TL";
            stage.quality = "medium";
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            var bm : Bitmap = new Bitmap(bmd = new BitmapData(512, 512, false));
            bm.x = bm.y = (465 - 512) >> 1;
            bm.opaqueBackground = 0x0;
            addChild(bm);

            /* cam */

            vid = new Video(512, 512);
            vid.attachCamera(Camera.getCamera());
            vid.smoothing = false;
            vid.deblocking = 1;

            vmtx = new Matrix(-1, 0, 0, 1, 512);
            vbmd = bmd.clone();

            ofscr = bmd.clone();

            /* shapes */

            var c0 : uint = 0x080402;
            var c1 : uint = 0x282422;
            var c2 : uint = 0x484442;
            var c3 : uint = 0x686462;
            var c4 : uint = 0x888482;
            var c5 : uint = 0xA8A4A2;
            var c6 : uint = 0xC8C4C2;
            var c7 : uint = 0xD8D4D2;
            var c8 : uint = 0xF8F4F2;

            var LO : Vector.<LO> = Vector.<LO>([new LO(c0, c1), new LO(c2, c3), new LO(c4, c5), new LO(c6, c7)]);
            var LX : Vector.<LX> = Vector.<LX>([new LX(c1, c2), new LX(c3, c4), new LX(c5, c6), new LX(c7, c8)]);

            shp = Vector.<Shape>([LO[0], LX[0], LO[1], LX[1], LO[2], LX[2], LO[3], LX[3], LX[3]]);

            shpm = new Matrix();
            shpr = new Rectangle();

            /* posterize */

            var cdiv : uint = 7;
            for (var i : int = 0; i < 256; i++) {
                var lum : uint = ((i / (256 / cdiv)) >> 0) * (255 / (cdiv - 1));
                cmap[i] = lum << 16;
            }

            /* go */

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            vbmd.draw(vid, vmtx);
            ofscr.paletteMap(vbmd, vbmd.rect, ofscr.rect.topLeft, cmap);
            
            bmd.lock();
            xoxo(0, 0, 512, ofscr, bmd);
            bmd.unlock();
        }

        private function xoxo(zx : uint, zy : uint, zs : uint, inBmd : BitmapData, outBmd : BitmapData) : void {
            if (zs <= 4) return;

            /* get standard deviation */

            shpr.x = zx;
            shpr.y = zy;
            shpr.width = zs;
            shpr.height = zs;

            var hist0 : Vector.<Number> = inBmd.histogram(shpr)[0];

            var np : uint = zs * zs;
            var avg : uint = ((hist0[127] * 127) + (hist0[255] * 255)) / np;
            var d : uint = -avg;

            var sum : uint;
            sum += d * d * hist0[0];
            d = 127 - avg;
            sum += d * d * hist0[127];
            d = 255 - avg;
            sum += d * d * hist0[255];

            if ((sum / np) > (1 << 7)) {
                var hs : uint = zs >> 1;

                xoxo(zx, zy, hs, inBmd, outBmd);
                xoxo((zx + hs), zy, (zs - hs), inBmd, outBmd);
                xoxo(zx, (zy + hs), hs, inBmd, outBmd);
                xoxo((zx + hs), (zy + hs), (zs - hs), inBmd, outBmd);
            } else {
                sum = 0;
                var i : uint = 256;
                while (i-- != 0) sum += i * hist0[i];

                shpm.a = zs / 64;
                shpm.d = zs / 64;
                shpm.tx = zx;
                shpm.ty = zy;

                var pos : uint = (((sum / np) / 256) * shp.length) >> 0;

                outBmd.draw(shp[pos], shpm);
            }
        }
    }
}

import flash.display.Shape;


internal class LO extends Shape {
    function LO(c0 : uint, c1 : uint) {
        graphics.beginFill(c0);
        graphics.drawRect(0, 0, 64, 64);

        graphics.beginFill(c1);
        graphics.drawCircle(32, 32, 32);
        graphics.drawCircle(32, 32, 32 - 16);
    }
}

internal class LX extends Shape {
    function LX(c0 : uint, c1 : uint) {
        graphics.beginFill(c0);
        graphics.drawRect(0, 0, 64, 64);

        var thk : Number = 8 * Math.SQRT2;

        graphics.beginFill(c1);
        graphics.lineTo(thk, 0);
        graphics.lineTo(32, 32 - thk);
        graphics.lineTo(64 - thk, 0);
        graphics.lineTo(64, 0);
        graphics.lineTo(64, thk);
        graphics.lineTo(32 + thk, 32);
        graphics.lineTo(64, 64 - thk);
        graphics.lineTo(64, 64);
        graphics.lineTo(64 - thk, 64);
        graphics.lineTo(32, 32 + thk);
        graphics.lineTo(thk, 64);
        graphics.lineTo(0, 64);
        graphics.lineTo(0, 64 - thk);
        graphics.lineTo(32 - thk, 32);
        graphics.lineTo(0, thk);
        graphics.lineTo(0, 0);
    }
}