/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/uA4h
 */

// MouseDownで切り替え。
// 
// fillRectとcopyPixelsの組み合わせはカクカクした印象。
// drawを使うと重いが良い感じになる。
// 
// waterSurfaceもscrollするだけじゃなくてもっと別な方法を使ってみたい。
package {
    import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.ByteArray;
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 20)]
    public class C extends Sprite {
		private const SIZE:Number = 465;
		private var src:Shape;
		private var bdsrc:BitmapData;
		private var bmpdata:BitmapData;
		private var watersurface:BitmapData;
		
		private var isDraw:Boolean = false;
		
        public function C() {
			src = new Shape();
			src.graphics.beginFill(0xFFFFFF);
			src.graphics.drawCircle(20, 20, 20);
			src.graphics.endFill();
			
			bdsrc = new BitmapData(40, 40, true, 0xFFFFFFFF);
			
			bmpdata = new BitmapData(SIZE, SIZE, true, 0xFF000000);
			watersurface = new BitmapData(SIZE, SIZE, false,0x808080);
			createWatersurface();
			addChild(new Bitmap(bmpdata));
			//addChild(new Bitmap(watersurface));
			addEventListener(Event.ENTER_FRAME, loop);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:Event):void {
				createWatersurface();
				isDraw = !isDraw;
			} );
		}
		private function createWatersurface():void
		{
			watersurface.perlinNoise(SIZE / 4, SIZE / 4, 2, Math.random() * 0xFFFFFFFF, true, true, 1 | 2);
		}
		private function loop(e:Event):void
		{
			bmpdata.lock();
			bmpdata.fillRect(bmpdata.rect, 0xFF000000);
			var m:Matrix = new Matrix();
			var ct:ColorTransform = new ColorTransform();
			for (var i:int = 0; i < watersurface.height; i+=20) {
				for (var j:int = 0; j < watersurface.width; j += 20) {
					var col:uint = watersurface.getPixel(j, i);
					var x:Number = ((col >> 16 & 0xFF) - 128) / 128;
					var y:Number = ((col >> 8 & 0xFF) - 128) / 128;
					var d:Number = Math.sqrt(x * x + y * y) / 1.41421356;
					x = j + x * 80 - bdsrc.width / 2;
					y = i + y * 80 - bdsrc.height / 2;
					if (!isDraw) {
						d = ((0.5 - d) > 0)?(1 - d * 2):0;
						bdsrc.fillRect(bdsrc.rect, (0xC0 * d*d) * 0x01000000 | 0xFFFFFF);
						bmpdata.copyPixels(bdsrc, bdsrc.rect,
							new Point(x, y),
							null, null, true);
					}else {
						d = 1 - d;
						m.identity();
						m.scale(d, d);
						m.translate(x, y);
						ct.alphaMultiplier = d * .3;
						bmpdata.draw(src, m, ct, BlendMode.ADD, null, false);
					}
				}
			}
			bmpdata.unlock();
			bitmapScroll(watersurface, 2, 4);
			//removeEventListener(Event.ENTER_FRAME, loop);
		}
		private function bitmapScroll(bitmapdata:BitmapData, x:int, y:int):void
		{
			var sizeWidth:Number = bitmapdata.rect.width;
			var sizeHeight:Number = bitmapdata.rect.height;
			var w:ByteArray;
            var h:ByteArray;
			if (x >= 0) {
			    h = bitmapdata.getPixels(new Rectangle(sizeWidth - x, 0, x, sizeHeight));
			}else {
			    h = bitmapdata.getPixels(new Rectangle(0, 0, -x, sizeHeight));
            }
			bitmapdata.scroll(x, 0);
			h.position = 0;
			if (x >= 0) {
			    bitmapdata.setPixels(new Rectangle(0, 0, x, sizeHeight), h);
			}else {
			    bitmapdata.setPixels(new Rectangle(sizeWidth + x, 0, -x, sizeHeight) , h);
			}
			
			if (y >= 0) {
			    w = bitmapdata.getPixels(new Rectangle(0, sizeHeight - y,  sizeWidth, y));
			}else {
			    w = bitmapdata.getPixels(new Rectangle(0, 0, sizeWidth, -y));
			}
			bitmapdata.scroll(0, y);
			w.position = 0;
			if (y>= 0) {
			    bitmapdata.setPixels(new Rectangle(0, 0, sizeWidth, y), w);
			}else {
			    bitmapdata.setPixels(new Rectangle(0, sizeHeight + y, sizeWidth, -y) , w);
			}
		}
    }
}