/**
 * Copyright Nendo ( http://wonderfl.net/user/Nendo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u93r
 */

// forked from Nendo's flash on 2010-2-3
package {
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import Error;
    import flash.external.ExternalInterface;
    
    import fl.transitions.TweenEvent;
    
    import caurina.transitions.Tweener;
    
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.objects.parsers.*;
    import org.papervision3d.objects.special.*;
    import org.papervision3d.Papervision3D;
    
    [SWF(backgroundColor="#20a0e2", frameRate=60)]
    
    public class Main extends Sprite {
            private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _viewPort:Viewport3D;
        private var _renderer:BasicRenderEngine;
        private var _my3dsObject:Collada;
        private var _mainObject:DisplayObject3D;
        private var _funcArray:Array;
        private var _spherer:int;
        private var _imgWidth:int;
        private var _imgHeight:int;
        private var _imageCount:int;
        private var _gsArr:Array;
        
        private var _wlimit:int;
        private var _hlimit:int;
        
        private var _xlimit:int;
        private var _ylimit:int;
        
        private var _horizontalAmount:int;
        private var _verticalAmount:int;
        
        private var _trans:String;
        private var _transc:String;
        
        private var _timeSprite:Timer;
        private var _timeNum:int;
        private var _timerCount:int;
        private var _moveTimer:int;
        private var _forceFunc:Function;
        private var _twObjArray:Array;
        
        public function Main():void{
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            //ステージの初期化
            setStage();
            
            //シーンの配置
            setScenes();
            
            //カメラの配置
            setCamera();
            
            defaultNumberSetting();
            
            photoTimer();
            
            makeTwObjects();
            
            funcArrInit();
            
            //3Dオブジェクトの配置
            setDO3D();
           
        }
        
        
        
        private function makeTwObjects():void{
            _twObjArray = new Array();
            _twObjArray[0] = new Object();
            _twObjArray[0] = {x:0,y:250,z:-550,time:6,transition:_transc};
            
            _twObjArray[1] = new Object();
            _twObjArray[1] = {x:0,y:0,z:-600,time:6,transition:_transc};
            
            _twObjArray[2] = new Object();
            _twObjArray[2] = {x:0,y:600,z:-400,time:6,transition:_transc};
            
            _twObjArray[3] = new Object();
            _twObjArray[3] = {x:50,y:-150,z:-500,time:6,transition:_transc};
            
            _twObjArray[4] = new Object();
            _twObjArray[4] = {x:20,y:20,z:-1000,time:6,transition:_transc};
            
            _twObjArray[5] = new Object();
            _twObjArray[5] = {x:0,y:0,z:-200,time:6,transition:_transc};
            
            _twObjArray[6] = new Object();
            _twObjArray[6] = {x:300,y:0,z:-600,time:6,transition:_transc};
        }
        
        
        private function defaultNumberSetting():void {
            _gsArr = new Array();
            _imgWidth = _imgHeight = 45;
            _imageCount = 100;
            _moveTimer = 3000 * 1.2;
            _horizontalAmount = 6;
            _verticalAmount = 5;
            _trans = "easeinoutback";
            _transc = "easeoutquad";
            _spherer = 60;
            _xlimit = stage.stageWidth / 2;
            _timerCount = 1;
            _ylimit = stage.stageHeight / 2;
        }
        
        private function photoTimer():void{
            _timeSprite = new Timer(_moveTimer);
            _timeNum = 0;
            _timeSprite.addEventListener(TimerEvent.TIMER, photoMover);
            _timeSprite.start();
        }
        
        private function photoMover(e:Event):void{
            if(_timeNum == _timerCount){
                drawLot();
                _timeNum = 0;
                cameraMove();
            }
            else{
                _timeNum++;
            }
        }
        
        private function drawLot() :void{
            var myFuncnno:int = Math.floor(Math.random() * _funcArray.length);
            if (myFuncnno == 6) {
                myFuncnno -= 1;
            }
            var myFunc:Function = _funcArray[myFuncnno];
            if(_forceFunc == myFunc){
                drawLot();
            }
            else {
                myFunc(_gsArr);
                _forceFunc = myFunc;
            }
        }
        
        private function setStage():void{
            addEventListener(Event.ENTER_FRAME, updateEnterFrameHundler);
        }
        
        private function updateEnterFrameHundler(e:Event):void {
            doRotateObject(_gsArr);
            _renderer.renderScene(_scene, _camera, _viewPort);
        }
        
        private function doRotateObject(planeArray:Array):void
        {
            var rotateMode:String;
            var myRand:int = int(Math.random() * 3);
            if(myRand==0)rotateMode= "rotationZ";
            else if(myRand==1)rotateMode= "rotationX";
            else rotateMode= "rotationY";
            for(var i:int = 0; i < planeArray.length; i++){
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                myPlane.rotationX += 6;
                myPlane.rotationY += 5;
                myPlane.rotationZ += 4;
            }
        }
        
        private function setDO3D():void {
            var myMaterial:WireframeMaterial = new WireframeMaterial(0x000000,1);
            for (var i:uint = 0; i < _imageCount; i++) {
                var iStr:String = String(i);
                var myMaterialList:MaterialsList = new MaterialsList( { all:myMaterial } );
                var myClone:DisplayObject3D = new Cube(myMaterialList, 150, 150, 150, 1, 1, 1);
                myClone.scale = 0.1;
                
                _scene.addChild(myClone);
                _gsArr.push(myClone);
            }
        }
        
        
        
        private function setScenes():void {
            _renderer = new BasicRenderEngine();
            _scene = new Scene3D();
            _viewPort = new Viewport3D(0, 0, true, true);
            _viewPort.autoClipping = true;
            _viewPort.autoCulling = true;
            addChild(_viewPort);
        }
        
        private function setCamera():void {
            _camera = new Camera3D();
            _camera.x = stage.stageWidth / 2;
            _camera.y = stage.stageHeight / 2;
            _camera.z = -1000;
            _camera.focus = 30;
            _camera.useCulling = true;
            _camera.useClipping = true;
            _camera.target = DisplayObject3D.ZERO;
        }
        
        //配置関数配列の初期化
        private function funcArrInit():void{    
            _funcArray = new Array();
            _funcArray[0] = new Function();
            _funcArray[0] = dress;
            
            _funcArray[1] = new Function();
            _funcArray[1] = explose;
            
            _funcArray[2] = new Function();
            _funcArray[2] = circle;
            
            _funcArray[3] = new Function();
            _funcArray[3] = spiral;
            
            _funcArray[4] = new Function();
            _funcArray[4] = cross;
            
            _funcArray[5] = new Function();
            _funcArray[5] = dressV;
            
            _funcArray[6] = new Function();
            _funcArray[6] = assemble;
        }
        
        //1点に集める
        private function assemble(planeArray:Array):void{
            var myX:Number = 0;
            var myY:Number = 0;
            var myRotate:Number = 0;
            for(var i:int = 0; i <planeArray.length; i++){
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                var myZ:Number = i*10;
                Tweener.addTween(myPlane,{x:myX,y:myY,z:myZ,rotationZ:myRotate,time:1.2,delay:0.1+0.02*i,transition:_trans});
            }
            cameraMove();
        }
        
        //十字
        private function cross(planeArray:Array):void{
            var sepNum:int = Math.ceil(planeArray.length / 2);
            var horArray:Array = planeArray.slice(0,sepNum);
            var verArray:Array = planeArray.slice(sepNum,planeArray.length);
            var myY:int = 0;
            //横処理
            for(var i:int = 0; i < horArray.length; i++){
                var myX:int = 0 - (_imgWidth*horArray.length / 2 ) + _wlimit / 2 + _imgWidth * i;
                var myPlane:DisplayObject3D = horArray[i] as DisplayObject3D;
                var myZ:int = 0;
                Tweener.addTween(myPlane,{x:myX,y:myY,z:myZ,rotationZ:0,time:1.2,delay:0.1+0.02*i,transition:_trans});
            }
            
            //縦処理
            var vyX:int = 0;
            for(var j:int = 0; j < verArray.length; j++){
                var vyPlane:DisplayObject3D = verArray[j] as DisplayObject3D;
                
                var vyY:int = 0 + (_imgHeight*verArray.length / 2) + _hlimit / 2 - _imgHeight*j;
                var vyZ:int = i*2;
                Tweener.addTween(vyPlane, { x:vyX, y:vyY, z:vyZ, rotationZ:0, time:1.2, delay:0.1 + 0.01 * j, transition:_trans } );
            }
            cameraMove();
        }
        
        //ランダム
        private function explose(planeArray:Array):void{
            
            for(var i:int = 0; i < planeArray.length; i++){
                var myX:Number = _xlimit / 2 - (Math.random()* _xlimit);
                var myY:Number = _ylimit / 2 - (Math.random()* _ylimit);
                var myZ:int = _ylimit - (Math.random()* _ylimit);
                var myRotationZ:Number = Math.random()*360;
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                
                Tweener.addTween(myPlane,{x:myX,y:myY,z:myZ,rotationZ:myRotationZ,time:1.2,delay:0.1+0.02*i,transition:_trans});
            }
            cameraMove();
        }
        
        
        //配列をランダムに並び替える関数
        private function shuffleArr(arr:Array,count:int):Array{
            var limitCount:int = count;
            var workArray:Array = arr.slice();
            var shuffledArray:Array = new Array();
            while(limitCount > 0){
                var myId:int = Math.floor(Math.random()*workArray.length);
                shuffledArray.push(workArray[myId]);
                workArray.splice(myId,1);
                limitCount--;
            }
            return shuffledArray;
        }
        
        //渦
        private function spiral(planeArray:Array):void{
            var circleAmount:Number = _imageCount / 5;
            var segAngle:Number = 360 / circleAmount;
            var angl:Number = 0;
            var tmpSpherer:Number = _spherer;
            _spherer *= 0.35;
            for(var i:int = 0; i < planeArray.length; i++){
                var myrad:Number = angl * Math.PI / 180;
                var myX:Number = _spherer * (Math.cos(myrad));
                var myY:Number = _spherer * (Math.sin(myrad));
                var myZ:int = (segAngle * i * 0.5);
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                Tweener.addTween(myPlane,{x:myX,y:myY,z:myZ,rotationY:0,rotationZ:angl,time:1.2,delay:0.1+0.02*i,transition:_trans});
                angl += segAngle;
                _spherer += _spherer / 20;
                if(angl > 360){
                    angl = 0;
                }
            }
            _spherer = tmpSpherer;
            cameraMove();
        }
        
        //円
        private function circle(planeArray:Array):void{
            var segAngle:Number = 360 / _imageCount;
            var angl:Number = 0;
            for(var i:int = 0; i < planeArray.length; i++){
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                var myrad:Number = angl * Math.PI / 180;
                var myX:Number = _spherer * 1.5 * (Math.cos(myrad));
                var myZ:Number = _spherer * 1.5 * (Math.sin(myrad));
                var myY:int = segAngle;
                Tweener.addTween(myPlane,{x:myX,y:myY,z:myZ,rotationY:0,rotationZ:0,time:1.2,delay:0.1+0.02*i,transition:_trans});
                angl += segAngle;
            }
            cameraMove();
        }
        
        //左上から右下に並べる関数
        private function dress(planeArray:Array):void{
            var verRate:Number = _imageCount / _horizontalAmount;
            
            var marRate:Number = _hlimit / verRate;
            
            var myY:int = 0 + _hlimit / 2 - _imgHeight / 2;
            
            var myZ:int = _imgHeight;
            
            for(var i:int = 0; i < planeArray.length; i++){
                var myX:int = 0 - _imgWidth*i + _wlimit / 2 + _imgWidth / 2;
                
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                if(i >= _horizontalAmount){
                    if(i % _horizontalAmount == 0){
                        myY -= _imgHeight;
                    }
                    myX += Math.floor(i / _horizontalAmount) * _imgWidth * _horizontalAmount;
                }
                Tweener.addTween(myPlane,{
                            x:myX,
                            y:myY,
                            z:myZ,
                            rotationZ:0,
                            time:1.2,
                            delay:0.1+0.02*i,
                            transition:_trans
                            }
                );
            }
            cameraMove();
        }
        
        //右上から左下に並べる関数
        private function dressV(planeArray:Array):void{
            var verRate:Number = _imageCount / _verticalAmount;
            var marRate:Number = _wlimit / verRate;
            var myX:int = 0 + _wlimit / 2 + _imgWidth;
            var myZ:int = _imgWidth;
            for(var i:int = 0; i < planeArray.length; i++){
                var myY:int = 0 - _imgHeight*i + _hlimit / 2 + _imgHeight / 2;
                var myPlane:DisplayObject3D = planeArray[i] as DisplayObject3D;
                
                if(i >= _verticalAmount){
                    if(i % _verticalAmount == 0){
                        myX -= _imgWidth;
                    }
                    myY += Math.floor(i / _verticalAmount) * _imgHeight * _verticalAmount;
                }
                Tweener.addTween(myPlane,{x:myX,y:myY,z:myZ,rotationZ:0,time:1.2,delay:0.1+0.02*i,transition:_trans}
                );
            }
            cameraMove();
        }
        
        private function cameraMove():void{
            Tweener.removeTweens(_camera);
            if(_forceFunc == spiral){
                Tweener.addTween(_camera,_twObjArray[0]);
            }
            else if(_forceFunc == dress){
                Tweener.addTween(_camera,_twObjArray[1]);
            }
            else if(_forceFunc == circle){
                Tweener.addTween(_camera,_twObjArray[2]);
            }
            else if(_forceFunc == dressV){
                Tweener.addTween(_camera,_twObjArray[3]);
            }
            else if(_forceFunc == cross){
                Tweener.addTween(_camera,_twObjArray[4]);
            }
            else if(_forceFunc == explose){
                Tweener.addTween(_camera,_twObjArray[5]);
            }
            else if(_forceFunc == assemble){
                Tweener.addTween(_camera,_twObjArray[6]);
            }
        }
    }
}