/**
 * Copyright LawrieCape ( http://wonderfl.net/user/LawrieCape )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u8kn
 */

package {

	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.events.*;
	import flash.geom.Point;
        import flash.display.DisplayObject;
        import flash.display.StageQuality;
        import flash.display.Stage;
        
	public class Main extends MovieClip {
    
        [SWF(backgroundColor=0xffffff, frameRate=120, height=450, width=450)]
        
        public var makeBalls:int = 200;
        public var movers:Array= [];
        public var divVar:int = 500;
        public var mouse:Object = {x:mouseX,y:mouseY}
        public var springDivider:Number = 25;
        public var constrainBounds:Boolean = false;
        public var SW:Number= stage.stageWidth;
        public var SH:Number= stage.stageHeight;

        public function Main():void{
            stage.quality = StageQuality.LOW;
            addEventListener(Event.ENTER_FRAME, updateMouse);
            addEventListener(MouseEvent.CLICK, mouseUpHandler);
            Construct(); 
        }
         
        public function Construct():void{
        for (var i:int = 0; i < makeBalls; i++) {
		movers[i] = makeMover(i);
		movers[i].addEventListener(Event.ENTER_FRAME, update);
		addChild(movers[i]);
	}
        }
        
public function makeMover(i:int):DisplayObject{
    var m:MovieClip = new MovieClip();//new M();
	m.graphics.beginFill( 0xFFCC0000, .5);
	m.graphics.drawCircle(0,0,5);
	m.location 		=  {x:SW/2,y:SH/2};
	m.velocity 		=  {x:0,y:0};
	m.acceleration  =  {x:0,y:0};
	m.topspeed 		=  (i/springDivider)+1;
	return m;
}

public function update(e:Event):void {
	var M:*   = e.currentTarget;
	var dir:Object = {x:mouseX-M.x,y:mouseY-M.y};
	M.acceleration.x = dir.x/divVar;
	M.acceleration.y = dir.y/divVar;
	M.velocity.x+=M.acceleration.x;
	M.velocity.y+=M.acceleration.y;
	if(M.velocity.x>M.topspeed){M.velocity.x=M.topspeed}
	if(M.velocity.y>M.topspeed){M.velocity.y=M.topspeed}
	if(M.velocity.x< -M.topspeed){M.velocity.x=-M.topspeed}
	if(M.velocity.y<-M.topspeed){M.velocity.y=-M.topspeed}
	M.location.x+=M.velocity.x;
	M.location.y+=M.velocity.y;
	M.x = M.location.x;
	M.y = M.location.y;
	if(constrainBounds){
		if (M.location.x > SW) {
			M.location.x = 0;
		} else if (M.location.x < 0) {
			M.location.x = SW;
		}
		if (M.location.y > SH) {
			M.location.y = 0;
		} else if (M.location.y < 0) {
			M.location.y = SH;
		}
	}
}

public function updateMouse(e:Event):void{
	mouse.x = mouseX;
	mouse.y = mouseY;
}

public function mouseUpHandler( e:Event):void {
		if(constrainBounds){constrainBounds=false}
		else{constrainBounds=true}
		reset();
}
public function reset():void{
	for (var i:int = 0; i < makeBalls; i++) {
		movers[i].removeEventListener(Event.ENTER_FRAME, update);
		movers[i].parent.removeChild(movers[i]);
	}
	movers = [];
        Construct();
}
}
}