/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u8hTs
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Rectangle;
 
    /*
    ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓
    ┃                                                   ┃
    ┃ 'And life is like a pipe,                         ┃
    ┃  and I'm a tiny penny                             ┃
    ┃  rolling up                                       ┃
    ┃  the walls inside.'                               ┃
    ┃                               -- Amy Winehouse -- ┃
    ┃━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┃
    ┃                                                   ┃
    ┃ '...and midpoint optimized,                       ┃
    ┃  like an integers rotated and shifted,            ┃
    ┃  manipulated bitwise.'                            ┃
    ┃                                   ~ Flash Mafia ~ ┃
    ┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛
    */
    public class TinyPennyRollingUpTheWalls extends Sprite
    {
        private const NUM_P : int = 22222;
        private const ECOS : Number = Math.cos(0.191986217719);
        private const ESIN : Number = Math.sin(0.191986217719);

         /* */

        private var _p : Particle;
        private var _bmd : BitmapData;
        private var _buff : Vector.<uint>;
        private var _prn : uint = 2222;

        public function TinyPennyRollingUpTheWalls()
        {
            /* */

            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.LOW;
            stage.frameRate = 64;
            stage.fullScreenSourceRect = new Rectangle(0, 0, 512, 512);
            opaqueBackground = 0x0;

            /* */

            var p : Particle = _p = new Particle();
            var ang : Number = 0.0;
            var n : uint = NUM_P;
            while (n-- != 0)
            {
                ang += ((Math.PI * 2) / NUM_P);
                p.x = p.x0 = (512 >> 1) + (333 - 60 + 120 * Math.random()) * Math.cos(ang);
                p.y = p.y0 = (512 >> 1) + (333 - 60 + 120 * Math.random()) * Math.sin(ang);
                
                p = p.next = new Particle();
            }

            /* */

            var bm : Bitmap = new Bitmap(_bmd = new BitmapData(512, 512, false));
            bm.opaqueBackground = 0x0;
            addChild(bm);

            _buff = new Vector.<uint>(512 * 512, true);

            /* */

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(arg1 : Event) : void {
            var cx : int = (512 >> 1);
            var cy : int = (512 >> 1);
            var prn : uint = _prn;

            /* */

            var blen : uint = _buff.length;
            var n : uint = blen;
            while (n-- != 0) _buff[n] = 0;

            /* */

            var p : Particle = _p;
            while (p != null)
            {
                var dx : int = p.x0 - cx;
                var dy : int = p.y0 - cy;

                p.x0 = cx + ECOS * dx - ESIN * dy;
                p.y0 = cy + ECOS * dy + ESIN * dx;

                p.x = p.x + (p.x0 - p.x) * 0.09;
                p.y = p.y + (p.y0 - p.y) * 0.01;

                n = p.y * 512 + p.x;
                if (n < blen) _buff[n] = (prn = (prn * 16807) & 2147483647) & 0xFFFFFF;

                p = p.next;
            }
  
            _prn = prn;

            /* draw */

            _bmd.setVector(_bmd.rect, _buff);
        }
    }
}
internal class Particle
{
    public var next : Particle;
    public var c : uint;
    public var x : int;
    public var y : int;
    public var x0 : int;
    public var y0 : int;

    function Particle() {}
}