/**
 * Copyright yangliu9812 ( http://wonderfl.net/user/yangliu9812 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u8XO
 */

// forked from Sylphy0721's flash on 2015-5-25
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;  
    import org.papervision3d.cameras.*;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*
    import org.papervision3d.materials.utils.*;
    //[SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "60")] 
    public class cubeMain extends BasicView {    
        public function cubeMain() {
            // BasicViewの初期化
            super(0, 0, true, false, CameraType.FREE);
            // カメラを原点に配置
            camera.x = camera.y = camera.z = 0;
            Security.allowDomain("kazumiworx.com");
            Security.loadPolicyFile("http://kazumiworx.com/crossdomain.xml");
            // 画質を「低」にして高速化
            stage.quality = StageQuality.LOW;
            // マテリアル(立方体の面を作成)
            var materials:MaterialsList = new MaterialsList(
            {
                front : new BitmapFileMaterial( "http://kazumiworx.com/kmmt15/images/v4_photo2_f.jpg", true ),
                back  : new BitmapFileMaterial( "http://kazumiworx.com/kmmt15/images/v4_photo2_b.jpg", true ),
                right : new BitmapFileMaterial( "http://kazumiworx.com/kmmt15/images/v4_photo2_r.jpg", true ),
                left  : new BitmapFileMaterial( "http://kazumiworx.com/kmmt15/images/v4_photo2_l.jpg", true ),
                top   : new BitmapFileMaterial( "http://kazumiworx.com/kmmt15/images/v4_photo2_u.jpg", true ),
                bottom: new BitmapFileMaterial( "http://kazumiworx.com/kmmt15/images/v4_photo2_d.jpg", true )
            });
            // キューブを作成
            var cube:Cube = new Cube( materials, 5000, 5000, 5000, 8, 8, 8, Cube.ALL, Cube.NONE );
            scene.addChild(cube);
            // マウスのインタラクティブを設定しています
            addEventListener(Event.ENTER_FRAME, loop);
            addEventListener(MouseEvent.MOUSE_WHEEL, wheelHandler);
            // レンダリングを開始します
            startRendering();
        }
        // マウスの位置に応じてインタラクティブを設定しています
        private function loop(e:Event):void {
            // カメラの目標となる視線方向を計算
            var rotY:Number = 480 * mouseX/(stage.stageWidth);
            var rotX:Number = 180 * mouseY/(stage.stageHeight) - 90;
            // イージングの公式を使ってカメラの値を更新
            camera.rotationY += (rotY - camera.rotationY) * 0.1;
            camera.rotationX += (rotX - camera.rotationX) * 0.1;
        }
        // マウスホイールでカメラのズーム値を調整します
        private function wheelHandler(e:MouseEvent):void {
            // ホイールの値をズーム値に加える
            camera.zoom += e.delta / 10;
            // カメラのズーム値は1以下にならないように指定
            if (camera.zoom < 1) camera.zoom = 1;
        }
        
    }
}