/**
 * Copyright hacker_lra4mj5w ( http://wonderfl.net/user/hacker_lra4mj5w )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u7aq
 */

// forked from hacker_lra4mj5w's [Stardust] Rain Umbrella
// forked from die's forked from: forked from: [Stardust] Rain
// forked from Rodlaiz's forked from: [Stardust] Rain

// forked from paq's [Stardust] Rain

package 

{
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.display.Loader;

    import flash.display.Bitmap;

    import flash.display.BitmapData;

    import flash.display.BitmapDataChannel;

    import flash.display.Graphics;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.events.TimerEvent;

    import flash.filters.BlurFilter;

    import flash.filters.ColorMatrixFilter;

    import flash.geom.ColorTransform;

    import flash.geom.Matrix;

    import flash.geom.Point;

    import flash.utils.getTimer;

    import flash.utils.Timer;

    import idv.cjcat.stardust.common.clocks.SteadyClock;

    import idv.cjcat.stardust.common.emitters.Emitter;

    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;

    

    /**

     * 雨を降らせてみた。

     * @author paq89

     */

    

    [SWF(width = 465, height = 337, backgroundColor = 0x000000, frameRate = 60)]

    public class Main extends Sprite 

    {

        private static const ZERO_POINT:Point = new Point(0, 0);

        

        private var bmpd:BitmapData            = new BitmapData(465, 337, true, 0);

        private var bmp:Bitmap                = new Bitmap(bmpd);
        
        private var bgLoader:Loader;
        
        private var bgBMP:Bitmap;

        private var container:Sprite        = new Sprite();

        private var obstacle:Obstacle        = new Obstacle();

        private var emitter:Emitter            = new RainEmitter(new SteadyClock(1), obstacle);

        private var blur:BlurFilter            = new BlurFilter(1.5, 1.5, 1);

        private var color:ColorMatrixFilter = new ColorMatrixFilter([

            1, 0, 0, 0, -5,

            0, 1, 0, 0, -5,

            0, 0, 1, 0, -5,

            0, 0, 0, 1, 0

        ]);

        

        public function Main():void 

        {

            if (stage) init();

            else addEventListener(Event.ADDED_TO_STAGE, init);

        }

        
        private function loadBG():void 
        {
            bgLoader = new Loader();
            bgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE,function(event:Event):void{
            
                event.currentTarget.removeEventListener(event.type,arguments.callee);
                var bitmapData:BitmapData = Bitmap(event.currentTarget.content).bitmapData;
                bgBMP = new Bitmap( bitmapData ); 
                
                var background:Sprite = new Sprite();
                var g:Graphics = background.graphics;
                g.beginFill(0x000000);
                g.drawRect(0, 0, 465, 337);
                background.addChild( bgBMP );
    
                var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(container);
                renderer.addEmitter(emitter);;
    
                
    
                addChild(background);
    
                addChild(bmp);
    
                addChild(obstacle)
    
                stage.addEventListener(Event.ENTER_FRAME, loop);
    
                // stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
                
                obstacle.x = 360;
                obstacle.y = 150;
                
                obstacle.circleDeflector.x = obstacle.x;

                obstacle.circleDeflector.y = obstacle.y;

                RainEmitter(emitter).circleZone.x = obstacle.x;

                RainEmitter(emitter).circleZone.y = obstacle.y;
                
                
            });        
        
            bgLoader.load(new URLRequest("http://www.gugateider.com/experiments/rainyday/rainydaybg1.jpg"),new LoaderContext(true));
        
        }

        
        
        private function init(e:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            loadBG();

        }

        

        private function loop(e:Event):void

        {

            emitter.step();

            bmpd.applyFilter(bmpd, bmpd.rect, ZERO_POINT, color);

            bmpd.applyFilter(bmpd, bmpd.rect, ZERO_POINT, blur);

            bmpd.draw(container);

        }

        

        private function onMouseMove(e:MouseEvent):void

        {

            obstacle.x = stage.mouseX;

            obstacle.y = stage.mouseY;

            obstacle.circleDeflector.x = obstacle.x;

            obstacle.circleDeflector.y = obstacle.y;

            RainEmitter(emitter).circleZone.x = obstacle.x;

            RainEmitter(emitter).circleZone.y = obstacle.y;

            if (e) e.updateAfterEvent();

        }

    }

    

}
import flash.display.Bitmap;
import flash.events.Event;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.display.Loader;



import flash.display.Sprite;

import flash.display.BitmapData;

import flash.events.MouseEvent;

import frocessing.color.ColorHSV;

import idv.cjcat.stardust.common.actions.CompositeAction;

import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;

import idv.cjcat.stardust.common.clocks.Clock;

import idv.cjcat.stardust.common.initializers.CollisionRadius;

import idv.cjcat.stardust.common.initializers.Mask;

import idv.cjcat.stardust.common.initializers.Mass;

import idv.cjcat.stardust.common.initializers.Scale;

import idv.cjcat.stardust.common.math.UniformRandom;

import idv.cjcat.stardust.twoD.actions.DeathZone;

import idv.cjcat.stardust.twoD.actions.Deflect;

import idv.cjcat.stardust.twoD.actions.Gravity;

import idv.cjcat.stardust.twoD.actions.Move;

import idv.cjcat.stardust.twoD.actions.Oriented;

import idv.cjcat.stardust.twoD.actions.Spawn;

import idv.cjcat.stardust.twoD.actions.SpeedLimit;

import idv.cjcat.stardust.twoD.deflectors.CircleDeflector;

import idv.cjcat.stardust.twoD.emitters.Emitter2D;

import idv.cjcat.stardust.twoD.fields.BitmapField;

import idv.cjcat.stardust.twoD.fields.UniformField;

import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;

import idv.cjcat.stardust.twoD.initializers.Position;

import idv.cjcat.stardust.twoD.initializers.Velocity;

import idv.cjcat.stardust.twoD.zones.CircleZone;

import idv.cjcat.stardust.twoD.zones.LazySectorZone;

import idv.cjcat.stardust.twoD.zones.Line;

import idv.cjcat.stardust.twoD.zones.RectZone;

import idv.cjcat.stardust.twoD.zones.SinglePoint;



class RainEmitter extends Emitter2D

{

    private var _circleZone:CircleZone = new CircleZone(0,0,50);

    

    public function RainEmitter(clock:Clock, obstacle:Obstacle)

    {

        super(clock);

            

        var spawn:Spawn = new Spawn(new UniformRandom(3, 1));

        var lazySector:LazySectorZone = new LazySectorZone(2.5, 1.5);

        lazySector.direction.set(0, 1);

        lazySector.directionVar = 70;

        spawn.addInitializer(new Velocity(lazySector));

        spawn.addInitializer(new Position(new SinglePoint(0, -10)));

        spawn.addInitializer(new Mask(2));

        spawn.addInitializer(new DisplayObjectClass(Rain));

        spawn.addInitializer(new Scale(new UniformRandom(0.2, 0.8)));

        

        addInitializer(new Mask(1));

        addInitializer(new DisplayObjectClass(Rain));

        addInitializer(new Position(new Line(0, 0, 465, 0)));

        addInitializer(new Scale(new UniformRandom(0.2, 1)));

        

        var gravity:Gravity = new Gravity();

        gravity.addField(new UniformField(0, 0.2));

        var deflect:Deflect = new Deflect();

        deflect.addDeflector(obstacle.circleDeflector);

        var commonActions:CompositeAction = new CompositeAction();

        commonActions.mask = 1 | 2;

        commonActions.addAction(gravity);

        commonActions.addAction(deflect);

        commonActions.addAction(new Move());

        commonActions.addAction(new Oriented());

        commonActions.addAction(new DeathZone(new RectZone(0, 0, 465, 337), true));

        commonActions.addAction(new DeathZone(_circleZone, false));

        addAction(commonActions);

        

        var deathTrigger:DeathTrigger = new DeathTrigger();

        deathTrigger.addAction(spawn);

        var dripActions:CompositeAction = new CompositeAction();

        dripActions.mask = 1;

        dripActions.addAction(deathTrigger);

        addAction(dripActions);

    }

    

    public function get circleZone():CircleZone { 

        return _circleZone;

    }

    

    public function set circleZone(value:CircleZone):void 

    {

        _circleZone = value;

    }

}



class Obstacle extends Sprite {

    

    public var circleDeflector:CircleDeflector

    

    public function Obstacle() {

        x = 465 / 2;

        y = 465 / 2;

        graphics.lineStyle(1, 0xFFFFFF, 0);

        //graphics.beginFill(0xFFFFFF, 0.25);

        graphics.drawCircle(0, 0, 75);

        circleDeflector = new CircleDeflector(x, y, 75);

        circleDeflector.bounce = 0.3;
        
        
    }

}



class Rain extends Sprite 

{

    static private var col:int = 1;

    public function Rain():void 

    {

    
        //var color:ColorHSV = new ColorHSV(col+Math.random()*60>>0, 0.7);
        var color:ColorHSV = new ColorHSV(0xFFFFFF, 1);

        graphics.beginFill(0x85a9b9, Math.random() * 1);

        graphics.drawRect(0, 0, 2, 12);

    }

}