/**
 * Copyright tananuka13 ( http://wonderfl.net/user/tananuka13 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u7Qh
 */

// forked from ProjectNya's Sphere Pixels BitmapEffectLayer + Vertex3D (BitmapColorEffect) [Papervision3D]
////////////////////////////////////////////////////////////////////////////////
// Sphere Pixels BitmapEffectLayer + Vertex3D (BitmapColorEffect) [Papervision3D]
//
// キラキラ効果
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.PixelSnapping;
    import flash.display.BlendMode;
    import flash.geom.Matrix;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.core.geom.Pixels;
    import org.papervision3d.core.geom.renderables.Pixel3D;
    import org.papervision3d.view.layer.BitmapEffectLayer;
    import org.papervision3d.core.effects.BitmapColorEffect;
    import org.papervision3d.core.effects.utils.BitmapClearMode;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.materials.WireframeMaterial;
    import frocessing.color.ColorHSV;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var viewport:Viewport3D;
        private var renderer:BasicRenderEngine;
        private var pixels:Pixels;
        private var layer:BitmapEffectLayer;
        private var sphere:Sphere;
        private var hsv:ColorHSV;
        private static var radius:uint = 500;
        private var angle:Number = 90;
        private var degree:Number = 0;
        private static var depression:uint = 45;
        private static var radian:Number = Math.PI/180;
        private var bitmapData:BitmapData;
        private var matrix:Matrix;
        private static var scale:uint = 8;

        public function Main() {
            //Wonderfl.capture_delay(1);
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            scene = new Scene3D();
            camera =new Camera3D();
            viewport = new Viewport3D(0, 0, true, false);
            renderer = new BasicRenderEngine();
            setup();
            initialize();
            addChild(viewport);
            addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }
        private function setup():void {
            camera.x = 0;
            camera.y = 0;
            camera.z = radius;
            camera.zoom = 25;
            camera.focus = 20;
            camera.target = DisplayObject3D.ZERO;
        }
        private function initialize():void {
            effect();
            layer = new BitmapEffectLayer(viewport, 465, 465, true, 0x00000000, BitmapClearMode.CLEAR_PRE);
            viewport.containerSprite.addLayer(layer);
            layer.addEffect(new BitmapColorEffect(1, 1, 1, 0.8));
            pixels = new Pixels(layer);
            scene.addChild(pixels);
            var material:WireframeMaterial = new WireframeMaterial(0xFFFFFF, 1, 0);
            sphere = new Sphere(material, 160, 60, 30);
            hsv = new ColorHSV();
            var max:uint = sphere.geometry.vertices.length;
            for (var n:uint = 0; n < max; n++) {
                if (n == 0 || n == max - 1) {
                    hsv.h = 0;
                    hsv.s = 0;
                } else {
                    hsv.h = 360/60*n;
                    hsv.s = 1;
                }
                var color:uint = 0xFF << 24 | hsv.value;
                var vertex:Vertex3D = sphere.geometry.vertices[n];
                pixels.addPixel3D(new Pixel3D(color, vertex.x, vertex.y, vertex.z));
            }
        }
        private function effect():void {
            bitmapData = new BitmapData(465/scale, 465/scale, false, 0xFF000000);
            var bitmap:Bitmap = new Bitmap(bitmapData, PixelSnapping.NEVER, true);
            bitmap.scaleX = bitmap.scaleY = scale;
            bitmap.blendMode = BlendMode.ADD;
            addChild(bitmap);
            matrix = new Matrix(1/scale, 0, 0, 1/scale, 0, 0);
        }
        private function render(evt:Event):void {
            sparkle();
            angle ++;
            degree += 2;
            var dip:Number = depression*Math.sin(degree*radian);
            camera.x = radius*Math.cos(angle*radian)*Math.cos(dip*radian);
            camera.y = radius*Math.sin(dip*radian);
            camera.z = radius*Math.sin(angle*radian)*Math.cos(dip*radian);
            //layer.fillCanvas(0x00000000);
            renderer.renderScene(scene, camera, viewport);
        }
        private function sparkle():void {
            bitmapData.lock();
            bitmapData.fillRect(bitmapData.rect, 0xFF000000);
            bitmapData.draw(viewport, matrix);
            bitmapData.unlock();
        }

    }

}
