/**
 * Copyright naoto5959 ( http://wonderfl.net/user/naoto5959 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u7IO
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    /**
     * よく忘れるのでgetter/setterテストをして思い出してみた
     * @author naoto.koshikawa a.ka naoto5959
     */
    public class FlashTest extends Sprite {
        //----------------------------------------------------------------------
        //  properties
        //----------------------------------------------------------------------
        //------------------------------
        //  public propeties
        //------------------------------
        private var _score:int = 0;
        /**
         * readonly score
         */
        public function get score():int
        {
            return _score;
        }
        
        private var _count:int = 0;
        /**
         * write only
         */
        public function set count(value:int):void
        {
            _count = value;
        }
        
        private var _color:uint = 0x000000;
        /**
         * public color
         */
        public function get color():uint
        {
            _count++;
            return _color;
        }
        /** @private */
        public function set color(value:uint):void
        {
            _color = value;
        }
        
        //------------------------------
        //  private properties
        //------------------------------
        /**
         * debug text
         */
        private var _debugText:TextField;
        
        //----------------------------------------------------------------------
        //  method
        //----------------------------------------------------------------------
        //------------------------------
        //  public method
        //------------------------------
        /**
         * constructor
         */
        public function FlashTest()
        {
            _score = 100;
            // score = 100; // NG setterが必要
            print(String(score));
            
            _count = 0;
            count = 1;
            // print(String(count)); // NG　getterが必要
            // count++; // NG getterが必要
            // count += 2; // NG getterが必要(しつこい)
            
            print("1st count:" + String(_count));
            color = 0x00FFFF;
            print("2nd count:" + String(_count));
            color += 0xFF0000; // 3rdの出力を見れば, colorのgetterが呼ばれていることが分かる。
            print("3rd count:" + String(_count));
        }
        
        //------------------------------
        // private method
        //------------------------------
        /**
         * debug print
         */
        private function print(text:String):void
        {
            if (!_debugText)
            {
                addChild(_debugText = new TextField());
                _debugText.autoSize = TextFieldAutoSize.LEFT;
            }
            _debugText.appendText(text + "\n");
        }
    }
}