/**
 * Copyright mikesoylu ( http://wonderfl.net/user/mikesoylu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u6yl
 */

/*
 * Barış Michael Soylu 2011
 * this is the main part of the cave generator of Pixlander 2: Infinilander
 * you may use it as you please
 */

package
{
	import flash.display.*;
	import flash.geom.*;
	public class CaveGenerator extends Sprite
	{
        // the level bitmap
		public var _bmd:BitmapData = new BitmapData(_w,_h,false,0);
                
		private var _w:int = 128;
		private var _h:int = 128;
		private var _p:Point = new Point();
		private static var _seed:uint;

		public function CaveGenerator()
		{
            // this is set by the user
			_seed = Math.random()*10000;
                        
            // size of the map +-2
			var size:int = 10;
			
            // try until we have a suitable map
            var numTries:uint = 0;
			do
			{
				init();
				pick();
                numTries++;
				_bmd.floodFill(_p.x, _p.y, 0xFFFF0000);
				var r:Rectangle = _bmd.getColorBoundsRect(0xFFFFFFFF, 0xFFFF0000);
			}
			while(r.width>size+2 || r.height>size+2 || r.width<size-2 ||
                  r.height<size-2);
                        
			trace("generated map in "+numTries+" tries");
            // clipped bitmap data
            var bd:BitmapData = new BitmapData(r.width+2,r.height+3,false,0);
                        
			// copy map into temp bitmap data and make it black and white
			bd.threshold(_bmd, r, new Point(1,1), "==", 0xFFFF0000, 0xFFFFFFFF);

			// dispose old bitmap data
			_bmd.dispose();

			// assign temp to global bitmap data
			_bmd = bd;

			addChild(draw());
		}

		public static function random():Number
		{
			_seed = 69069*_seed + 362437;
			return Number(_seed)/0xFFFFFFFF;
		}
		private function init():void
		{
			_bmd.perlinNoise(4, 4, 1, random()*0xFFFFFFFF, false, false, 7, true);
			_bmd.threshold(_bmd, new Rectangle(0,0,_w,_h), new Point(), ">",
                           0xFF200000, 0xFF00FFFF);
		}
		private function pick():void
		{
			do
			{
				_p.x=int(random()*_w/4 + _w*0.375);
				_p.y=int(random()*_h/4 + _h*0.375);
			}
			while(_bmd.getPixel32(_p.x, _p.y) != 0xFF00FFFF);
		}
		public function draw():Bitmap
		{
			var bm:Bitmap = new Bitmap(_bmd);
			bm.scaleX = 150.0/_bmd.width;
			bm.scaleY = 150.0/_bmd.width;
			return bm;
		}
	}
}