/**
 * Copyright Murai ( http://wonderfl.net/user/Murai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u6HD
 */

////FIRE TANK 1.0

////toDo
//[x]set customSkinFile
//[x]add FireEffect
//[x]add FireBullet
//[ ]change smartAI

// forked from bentomorio's red tank
// forked from 9re's Wonderfl Tank Game Tank Sample 1
// このコードを新着タンク一覧http://flash-games.wonderfl.net/tank/list/new
// に表示させるにはinfinite-tank-entry
// というタグをつけてください

package {
	import flash.display.*;
	import flash.geom.*;
	import flash.utils.*;

	import net.wonderfl.game.infinity_tank.development.*;
	import net.wonderfl.math.*;
	import net.wonderfl.utils.SequentialLoader;

	/**
	 * @author Takashi Murai(KAYAC)
	 */
	[SWF( width="465", height="465", backgroundColor="0x000000", frameRate="30" )]

	public class Tank extends TankBase {
		private var _gunFlag:Boolean = true;
		private var _lastBulletCount:int = 0;
		private var _spTank:Sprite;
		private var _spBattery:Sprite;
		private var _ctfm:ColorTransform;
		private var _images:Vector.<Bitmap>;
		private var _gun:Bitmap;
		private var _arr:Array = [];
		private var _i:int = -1;
		private var _j:int = 0;
		private var _mat:Matrix = new Matrix();
		private var f:Fire

		public function Tank() {
			_bulletRenderer = "http://swf.wonderfl.net/swf/usercode/8/8b/8b32/8b32430e7252829db3b2ededd12c125694e9228c.swf";

			_spTank = new Sprite;
			_spBattery = new Sprite;

			SequentialLoader.loadImages([ "http://assets.wonderfl.net/images/related_images/6/65/6505/650528c2d07e515b9830b5fc0b0d4af045b5af83","http://assets.wonderfl.net/images/related_images/0/0e/0e4e/0e4e629d59f6fe11e4f3b038ee5e60a5f79093dc","http://assets.wonderfl.net/images/related_images/8/8c/8c47/8c47c76389b5f0672cfe73133314f54db798d250" ], _arr, onImageLoaded );

			_ctfm = new ColorTransform( 1, 1, 1, 0 );

			super();
		}

		private function onImageLoaded():void {
			_images = Vector.<Bitmap>( _arr.map( function( $ldr:Loader, $index:int, $arr:Array ):Bitmap {
										   var mat:Matrix = new Matrix;
										   var bd:BitmapData = new BitmapData( $ldr.width, $ldr.height, true, 0x00ffffff );
										   bd.draw( $ldr, mat );
										   var bm:Bitmap = new Bitmap( bd );
										   bm.x = -bm.width / 2;
										   bm.y = -bm.height / 2;

										   return bm;
									   }));

			_gun = _images.pop();
			_gun.x = -5;
			_gun.y = -5;
			_spBattery.addChild( _gun );
			_i = 0;
			_images.forEach( function( $bm:Bitmap, $index:int, $vec:Vector.<Bitmap> ):void {
					_spTank.addChild( $bm );
				});
			_spTank.addChild( _spBattery );
			f = new Fire( _spTank )
		}

		// 5フレームに1度呼ばれるcallback
		// 現在のゲームの状態を見るには、_sceneオブジェクトのプロパティーを
		// 調べます.
		// @see http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/development/BattleScene.html
		override public function action():int {
			// 前回のactionで弾が撃たれたかどうかを調べる.
			// 人対AIのゲーム・バランスのために弾は同画面内に最大3発までしか
			// 撃てない.
			if ( _lastBulletCount < _scene.myBulletCount ) {
				// 前回た弾を撃っている場合は、撃たないようにフラグをセット
				_gunFlag = false;
				// 400ms後にフラグを解除
				setTimeout( clearGunFlag, 400 );
			}
			// 現在の画面内にある弾の数を保存する.
			_lastBulletCount = _scene.myBulletCount;
			// フラグによって、撃つか撃たないかを判断
			var action:int = ( _gunFlag ) ? Command.FIRE : Command.DO_NOTHING;

			// 敵の位置を取得.
			var enemyPos:WVector2D = _scene.enemyTankPosition;
			// 自分の位置を敵の位置から引く.
			// 自分から見た敵の位置を計算
			enemyPos.subtract( _scene.myTankPosition );

			// 自分からみた敵の方向を計算する.
			var angle:Number = Math.atan2( enemyPos.y, enemyPos.x );
			// 敵の方向をコピー
			var direction:Number = angle;

			// 敵の方向と自分の砲台の向いている方向の差を計算
			angle -= ( _scene.myTankAngle + _scene.myGunAngle );
			// 敵の方向と自分のタンクの向いている方向の差を計算
			direction -= _scene.myTankAngle;

			// 角度を0～2πに丸める
			angle = WMath.modulo2PI( angle );
			direction = WMath.modulo2PI( direction );

			// 角度が0～πの場合は敵は砲台より右側にいる.
			if ( angle <= Math.PI )
				action |= Command.GUN_TURN_RIGHT;
			// 角度がπより大きい場合は敵は砲台の左側にいる.
			else
				action |= Command.GUN_TURN_LEFT;

			// 角度が0～πの場合は敵は自分の向いている方向の右側にいる.
			if ( direction <= Math.PI )
				action |= Command.TANK_TURN_RIGHT;
			// 角度がπより大きい場合は敵は自分の向いている方向の左側にいる.
			else
				action |= Command.TANK_TURN_LEFT;

			// 許容する角度を-π/4～π/4にセットし、
			var allow:Number = Math.PI / 4;

			// 敵が許容角度の範囲内に居るなら敵に前進する.
			// (敵の方向に向かって前進)
			if (( direction < allow ) || ( direction > WMath.DOUBLE_PI - allow ))
				action |= Command.TANK_MOVE_FORWARD;

			return action;
		}

		private function clearGunFlag():void {
			_gunFlag = true;
		}

		// 毎フレームごとに呼ばれる描画callback
		// stageと同じ大きさのBitmapDataが渡されます.
		// 現在のゲームの状態を見るには、_sceneオブジェクトのプロパティーを
		// 調べます.
		// @see http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/development/BattleScene.html
		override public function draw( bitmapData:BitmapData ):void {
			// 砲台の向きをセットします.
			// 砲台はタンクのSpriteの子供のスプライトです.
			_spBattery.rotation = _scene.myGunAngle * 180 / Math.PI;
			_spTank.rotation = _scene.myTankAngle * 180 / Math.PI;

			if ( _i > -1 ) {
				_i = ( _j & 1 ) ? 1 : 0;
				var bm:Bitmap = _images[ _i ];
				bm.visible = true;
				_i = 1 - _i;
				bm = _images[ _i ];
				bm.visible = false;
				_j++;
				_j &= 3;
			}

			// 単位行列にセット
			_mat.identity();
			// タンクの傾きをセット
			_mat.rotate( _scene.myTankAngle );
			// タンクの位置に平行移動. タンクのグラフィックは中心座標となっています.
			_mat.translate( _scene.myTankPosition.x, _scene.myTankPosition.y );

			// 一度BitmapDataをクリア
			bitmapData.colorTransform( bitmapData.rect, _ctfm );

			// BitmapDataを描画
			bitmapData.draw( _spTank, _mat, null, null, null, true );

			if ( !f ) {
				return
			}

			var bmd:BitmapData = f.getBMD()

			_mat.identity();
			_mat.translate( -bmd.width / 2, -bmd.height / 2 )
			_mat.translate( _scene.myTankPosition.x + _spTank.width / 2, _scene.myTankPosition.y + _spTank.height / 2 );

			bitmapData.draw( bmd, _mat, null, BlendMode.ADD )
		}

		// called when a bullet hits this tank
		override public function hit():void {
			// 被弾したときに呼ばれるcallbackです.
		}

		// called when this tank fires
		override public function fire():void {
			// 弾が発射される時に呼ばれるcallbackです.
		}
	}
}

import flash.display.*;
import flash.events.*;
import flash.filters.*;
import flash.geom.*;

internal class Fire extends Sprite {
	private const FADE:Number = 0.1;
	private const SCALE:Number = 0.35;
	private const DISTORTION:Number = 1;
	private const AMOUNT:Number = 0.4;
	private const SPREAD:Number = 1;
	private const SMOKE:Number = 0;

	private var src:*
	private var canvas:Bitmap
	private var main_bmp:BitmapData;
	private var tmp_bmp:BitmapData;
	private var perlin_bmp:BitmapData;

	private var _matrix:Matrix;
	private var _Pt:Point;
	private var _ctf:ColorTransform;
	private var _cmf:ColorMatrixFilter;
	private var _dmf:DisplacementMapFilter;
	private var _blur:BlurFilter;

	private var _target:DisplayObject;

	private var originalW:Number
	private var originalH:Number

	public function Fire( _src:DisplayObject = null ) {
		if ( !_src ) {
			src = new Sprite();
			src.graphics.beginFill( 0xFFFFFF, 1 );
			src.graphics.drawEllipse( 0, 0, 20, 40 )
			src.graphics.endFill();
		} else {
			src = _src
		}

		canvas = new Bitmap()
		_target = src;

		//		canvas.x = stage.stageWidth / 2;
		//		canvas.y = stage.stageHeight / 2;
		addChild( canvas );

		_matrix = new Matrix();
		_Pt = new Point();

		init()
		start();
	}

	public function getBMD():BitmapData {
		return this.canvas.bitmapData
	}

	private function start():void {
		addEventListener( Event.ENTER_FRAME, burn );
	}

	private function init():void {
		if ( main_bmp ) {
			main_bmp.dispose();
			main_bmp = null;
			tmp_bmp.dispose();
			tmp_bmp = null;
			perlin_bmp.dispose();
			perlin_bmp = null;
		}

		originalW = _target.width
		originalH = _target.height

		var w:Number = originalW * 6;
		var h:Number = originalH * 6;

		main_bmp = new BitmapData( w, h, true, 0 );
		tmp_bmp = main_bmp.clone();
		perlin_bmp = new BitmapData( w * 3, h * 3, false, 0 );
		canvas.bitmapData = main_bmp;

		perlin_bmp.perlinNoise( 30 * SCALE, 20 * SCALE, 1, -Math.random() * 1000 | 0, false, true, 1 | 2, false );
		perlin_bmp.colorTransform( perlin_bmp.rect, new ColorTransform( 1, 1 - AMOUNT * 0.5, 1, 1, 0, 0, 0, 0 ));

		_cmf = new ColorMatrixFilter([ 0.96-0.35*FADE,0.1,0,0,-1,   0,0.9-0.45*FADE,0,0,0,   0,0,0.8-0.55*FADE,0,0,   0,0.1,0,1,-25+SMOKE*24 ]);
		_ctf = new ColorTransform( 0, 0, 0, 1, 255, 255, 210, 0 );
		_dmf = new DisplacementMapFilter( perlin_bmp, _Pt, 1, 2, 14 * DISTORTION, -30, DisplacementMapFilterMode.CLAMP );
		_blur = new BlurFilter( 32 * SPREAD, 32 * SPREAD, 1 );
	}

	private function burn( e:Event ):void {

		var dM:Matrix = _target.transform.matrix;
		dM.tx = originalW * 6 / 2 - originalW / 2
		dM.ty = originalH * 6 / 2 - originalH / 2

		tmp_bmp.fillRect( tmp_bmp.rect, 0 );
		_ctf.alphaOffset = -Math.random() * 200 | 0;
		tmp_bmp.draw( _target, dM, _ctf, BlendMode.ADD );
		tmp_bmp.applyFilter( tmp_bmp, tmp_bmp.rect, _Pt, _blur );
		main_bmp.draw( tmp_bmp, _matrix, null, BlendMode.ADD );

		_dmf.mapPoint = new Point( -Math.random() * ( perlin_bmp.width - main_bmp.width ) | 0, -Math.random() * ( perlin_bmp.height - main_bmp.height ) | 0 );
		main_bmp.applyFilter( main_bmp, main_bmp.rect, _Pt, _dmf );
		main_bmp.applyFilter( main_bmp, main_bmp.rect, _Pt, _cmf );

	}
}