/**
 * Copyright genny ( http://wonderfl.net/user/genny )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u5CS
 */

package
{

	import flash.display.*;
	import flash.utils.*;
	import flash.events.*;
	import flash.text.*;
	
	public class Clock extends Sprite
	{
		
		//	Propaty
		const HANKEI:int = 500;
		const CENTER_Z:int = 950;
		const SCREEN_Z:int = 400;
		const HOURS:int = 24;
		const MINUTES:int = 60;
		const SECONDS = MINUTES;
		
		var base:Sprite;
		var timer:Timer;
		
		
		//	「時」
		var hourTF:Array;
		var hourTFT:Array;
		var hourX:Array, hourY:Array, hourZ:Array, hourSize:Array;
		
		
		
		//	Constructer
		function Clock()
		{
			base = new Sprite();
			base.x = stage.stageWidth / 2;
			base.y = stage.stageHeight / 2;
			addChild( base );
			
			hourTF = new Array();
			hourTFT = new Array();
			hourX = new Array();
			hourY = new Array();
			hourZ = new Array();
			hourSize = new Array();
			
			for( var i:int = 0; i < SECONDS; i++ )
			{
				var sp:Sprite = new Sprite();
				var field:TextField = new TextField();
				hourTFT.push(field);
				sp.addChild(field);
				hourTF.push( sp );
				var num:int = hourTF.length;
				var rnd:uint = Math.random() * 0xFFFFFF;
				hourTF[ num - 1 ].graphics.beginFill(rnd);
				hourTF[ num - 1 ].graphics.drawCircle(0, 0, 30);
				hourTF[ num - 1 ].graphics.endFill();
				hourTF[ num - 1 ].alpha = Math.random();
				
				if( i < 10 )	hourTFT[ num - 1 ].text = "0" + i;
				else			hourTFT[ num - 1 ].text =  i;
				base.addChild( hourTF[ num - 1 ] );
				
				hourX.push( 0 );
				hourY.push( 0 );
				hourZ.push( 0 );
				hourSize.push( 1 );
				
			}
			
			timer = new Timer( 33 );
			timer.addEventListener( TimerEvent.TIMER, loop );
			timer.start();
			
		}
		
		
		
		
		//	Loopメソッド
		function loop( event:TimerEvent ) :void
		{
			
			var date:Date = new Date();
			var hours:int = date.getHours();
			var seconds:int = date.getSeconds();
			
			for( var i:int = 0; i < SECONDS; i++ )
			{
				var angle:Number = ( -seconds / SECONDS * Math.PI * 2 + i / SECONDS * Math.PI * 2 );	//	各MCの配置角度算出（環そのものの回転 + i番目の文字の配置角度）
				var theY:Number = HANKEI * Math.sin( angle );	//	Y座標の算出
				var theZ:Number = CENTER_Z - HANKEI * Math.cos( angle );	//	Z座標の算出
				
				//	徐々に座標移動させる
				hourX[i] += ( base.mouseX - hourX[i] ) / 4;
				hourY[i] += ( theY - hourY[i] ) / 4;
				hourZ[i] += ( theZ - hourZ[i] ) / 4;
				
				//	大きさ
				if( i == seconds )	hourSize[i] +=  ( 8 - hourSize[i] );
				else				hourSize[i] +=  ( 1 - hourSize[i] );
				
				//	2次元投影
				hourTF[i].x = hourX[i] * SCREEN_Z / hourZ[i];
				hourTF[i].y = hourY[i] * SCREEN_Z / hourZ[i];
				hourTF[i].scaleX = hourTF[i].scaleY = hourSize[i] * SCREEN_Z / hourZ[i];

			}
			
		}
		
		
	}
	
	
}