/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u58g
 */

package {
    import flash.geom.Point;
    
    import flash.events.Event;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private var _agents:Array = []
        
        public function FlashTest() {
            // write as3 code here..
            graphics.lineStyle(2, 0x0)
            graphics.moveTo(0, 300)
            graphics.lineTo(stage.stageWidth, 300)
            graphics.lineStyle()
            
            var agent:Agent
            for(var i:int=0; i<150; i++){
                agent = new Agent(20, 10)
                agent.x = 50 + Math.random() * 300
                agent.y = 10 - i * 20
                agent.setAccel(0, 0.1)
                addChild(agent)
                _agents.push(agent)
            }
            addEventListener("enterFrame", loop)
        }
        
        private function loop(e:Event):void {
            for each(var a:Agent in _agents){
                a.integrate()
            }
            for(var i:int=0; i<3; i++) constraints()
        }
        
        private function constraints():void {
            for(var i:int=0; i<_agents.length; i++){
                for(var j:int=i+1; j<_agents.length; j++){
                    push(_agents[i], _agents[j])
                }
            }
            for each(var a:Agent in _agents){
                if(a.y + a.height > 300){
                    a.y = 300 - a.height
                    a.setVel(0, 0)
                }
            }
        }
        
        private function push(a:Agent, b:Agent):void {
            if(a.hitTestObject(b)){
                var dx:Number, dy:Number
                /*if(a.vx - b.vx != 0){
                    if(a.x < b.x && b.x < a.right){
                        // a is left
                        dx = (a.right - b.x) * .52
                        a.x -= dx
                        b.x += dx
                    }else{
                        // b is left
                        dx = (b.right - a.x) * .52
                        a.x += dx
                        b.x -= dx
                    }
                }*/
                //if(a.vy != 0 || b.vy != 0){
                    if(a.y < b.y && b.y < a.bottom){
                        // a is top
                        dy = (a.bottom - b.y) * .5
                        a.y -= dy
                        b.y += dy
                        a.setVel(0, 0)
                    }else{
                        dy = (b.bottom - a.y) * .5
                        a.y += dy
                        b.y -= dy
                        b.setVel(0, 0)
                    }
                //}
            }
        }
        
    }
    
}

// outside of package //

import flash.display.Sprite;

class Agent extends Sprite {
    
    private var _width:Number, _height:Number
    private var _vx:Number = 0, _vy:Number = 0
    private var _ax:Number = 0, _ay:Number = 0
    
    public function Agent(w:Number, h:Number) {
        graphics.beginFill(Math.random() * 0xffffff)
        graphics.drawRect(0, 0, w, h)
        _width = w
        _height = h
    }
    
    public function setVel(vx:Number, vy:Number):void {
        _vx = vx ; _vy = vy
    }
    public function setAccel(ax:Number, ay:Number):void {
        _ax = ax ; _ay = ay
    }
    
    public function integrate():void {
        _vx += _ax
        _vy += _ay
        if(_vy > _height * 0.8) _vy = _height * 0.8
        x += _vx
        y += _vy
    }
    
    public function get right():Number { return x + _width }
    public function get bottom():Number { return y + _height }
    
    public function get vx():Number { return _vx }
    public function get vy():Number { return _vy }
    
}
