/**
 * Copyright alterna_in ( http://wonderfl.net/user/alterna_in )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u570
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import com.bit101.components.HUISlider;
	/**
	 * ...
	 * @author toshiki izumi
	 */
	
	public class BrownianMotion extends Sprite
	{
		private var sp:Sprite;
		
		private var spd:Number = 2;
		private var frq:Number = 2;
		private var cnt:int = 0;
		private var spdSlider:HUISlider;
		private var frqSlider:HUISlider;
		
		public function BrownianMotion()
		{
			sp = new Sprite();
			sp.graphics.beginFill(0x0)
			sp.graphics.drawCircle(0, 0, 10);
			sp.graphics.endFill();
			
			sp.x=(stage.stageWidth/2)-(sp.width/2);
			sp.y=(stage.stageHeight/2)-(sp.height/2);
			
			addChild(sp);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			
			spdSlider = new HUISlider(this, 10, 420, "SPD", spdChange);
			spdSlider.value = 2;
			frqSlider=new HUISlider(this, 10, 440, "FRQ", frqChange);
			frqSlider.value = 2;
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			cnt++;
			if (cnt % frq != 0) return;
			
			var deg:Number = Math.random() * 2 * Math.PI;
			sp.x += spd * Math.cos(deg);
			sp.y += spd * Math.sin(deg);
		}
		
		private function spdChange(e:Event):void {
			spd = spdSlider.value;
		}
		
		private function frqChange(e:Event):void {
			frq = frqSlider.value;
		}
		
	}

}