/**
 * Copyright cohakim ( http://wonderfl.net/user/cohakim )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u4wy
 */

package {
  import fl.transitions.*;
  import fl.transitions.easing.*;
  
  import flash.display.*;
  import flash.events.*;
  
  [SWF(backgroundColor=0x000000, frameRate=24, width=480, height=400)]

  public class Enemy3 extends MovieClip {
    // -------------------------------------------------------------------------
    //  literals
    // -------------------------------------------------------------------------

    public static const RADIUS:uint       = 3;
    public static const DIAMETER:uint     = RADIUS * 2;
    public static const FILL_COLOR:uint   = 0xFFCCFF;

    // -------------------------------------------------------------------------
    //  instance variables
    // -------------------------------------------------------------------------

    var tweens:Array = new Array();

    // -------------------------------------------------------------------------
    //  game state
    // -------------------------------------------------------------------------

    static var appearRate:Number = 2;
    static var scale:Number      = 1.0;

    // -------------------------------------------------------------------------
    //  constructor
    // -------------------------------------------------------------------------
    
    public function Enemy3() {
      super();
      addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
      addEventListener(Event.REMOVED_FROM_STAGE, onRemovedFromStage);

    }
    
    // -------------------------------------------------------------------------
    //  event handler
    // -------------------------------------------------------------------------
    
    private function onAddedToStage(e:Event) {
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    //
    //
    //
    private function onEnterFrame(e:Event) {
      generateEnemyFields();
    }
    
    //
    //
    //
    private function onMotionChange(e:TweenEvent) {
    }
    
    private function onRemovedFromStage(e:Event) {
      removeEventListener(Event.ENTER_FRAME, onEnterFrame);
      tweens.forEach(function(tw:Tween, index:int, array:Array) {
        tw.fforward();
      });
    }
    
    // -------------------------------------------------------------------------
    //  draw methods
    // -------------------------------------------------------------------------

    //
    // 敵オブジェクトを作成
    //
    private function generateEnemyFields() {
      var count:int = 0;
      while(count <= appearRate) {
        // 敵の出現位置を算出し、ステージに送る
        var enemy:Sprite = new Sprite();
        enemy.x = Math.random() * stage.stageWidth;
        enemy.y = Math.random() * DIAMETER;
        enemy.graphics.beginFill(FILL_COLOR);
        enemy.graphics.drawCircle(0, 0, RADIUS);
        addChild(enemy);
        
        // 敵の落下モーションを設定
        var tw:Tween;
        tw = new Tween(enemy, "y", None.easeNone, 0, stage.stageHeight, stage.stageHeight / 6, false);
        tw.addEventListener(TweenEvent.MOTION_CHANGE, onMotionChange);
        tw.addEventListener(TweenEvent.MOTION_FINISH, function (e:TweenEvent) {
          tweens.shift();
          removeChild(e.currentTarget.obj);
        });
        tweens.push(tw);
        
        count++;
      }
    }
  }
}
