/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u3rG
 */

/**
 *  yossy の 21 才のハッピーバースデー！
 */
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;

    import com.flashdynamix.utils.SWFProfiler;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.IObjectTween;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]

    public class Main extends Sprite
    {
        private var index:uint = 0;
        private var tmpText:TextField;

        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            SWFProfiler.init(this);

            tmpText = new TextField();
            tmpText.defaultTextFormat = new TextFormat("Arial", 36, 0x000000);
            tmpText.autoSize = TextFieldAutoSize.LEFT;

            showMessage();
        }

        private function showMessage():void
        {
            var i:uint, l:uint, b:uint,
                msg:String,
                sp:Sprite,
                bm:Bitmap,
                data:BitmapData,
                t1:ITween, t2:ITween,
                tl1:Array, tl2:Array;

            while (numChildren)
            {
                removeChildAt(0);
            }

            msg = messages[index++];
            index = index >= messages.length ? 0 : index;

            l = msg.length;

            b = stage.stageWidth - (l-1) * 38 >> 1;

            tl1 = [];
            tl2 = [];

            for (i=0; i<l; i++)
            {
                tmpText.text = msg.charAt(i);

                data = new BitmapData(tmpText.width, tmpText.height, true, 0);
                data.draw(tmpText);

                bm = new Bitmap(data);
                bm.x -= bm.width >> 1;
                bm.y -= bm.height >> 1;

                sp = new Sprite();
                sp.x = b + 38 * i;
                sp.y = -50;
                sp.addChild(bm);

                addChild(sp);

                t1 = BetweenAS3.to(sp, {
                    y: stage.stageHeight >> 1
                }, 2, Bounce.easeOut);
                t1 = BetweenAS3.delay(t1, .2 * i);

                tl1.push(t1);

                t2 = BetweenAS3.to(sp, {
                    y: stage.stageHeight + 50,
                    rotation: 540 - Math.random() * 1080
                }, 1, Quad.easeIn);
                t2 = BetweenAS3.delay(t2, .2 * i);

                tl2.push(t2);
            }
            t1 = BetweenAS3.parallelTweens(tl1);
            t2 = BetweenAS3.parallelTweens(tl2);

            t1 = BetweenAS3.serial(
                BetweenAS3.delay(t1, .5),
                BetweenAS3.delay(t2, 1)
            );

            t1.onComplete = showMessage;
            t1.play();
        }

        private var messages:Array = [
            "びーいんたらくてぃぶ",
            "おたんじょうび",
            "おめでとーございまーす！",
            "またそのうち",
            "のみにいきましょー！"
        ];
    }
}
