/**
 * Copyright y_tama ( http://wonderfl.net/user/y_tama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u3HL
 */

// forked from christian's PAN # 2'
package
{
    /*
    SOUND (LENGTH 12'') IS
    LEFT  CHANNEL SAMPLED FROM _ ROBERT HOOD : WHO TAUGHT YOU MATH
    RIGHT CHANNEL SAMPLED FROM _ OVAL : LINE EXTENSION
    //
    CLICK TO REDRAW
    */

    import flash.events.*;
    import flash.display.*;

    import flash.net.URLRequest;

    import flash.text.TextField;

    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    import flash.media.SoundLoaderContext;

    import frocessing.color.ColorHSV;

    [ SWF (width = '465', height = '465', backgroundColor = '0x000000', frameRate = '30')]

    public class PAN_2_TEST extends Sprite
    {
        private var URL : String = 'http://mm4d.free.fr/tracks/breaks/sample_b.mp3';

        private var color : ColorHSV = new ColorHSV ();

        private var W : Number, H : Number;

        private var trans : SoundTransform;
        private var chans : SoundChannel;
        private var sound : Sound;

        //

        private var lines : Shape = new Shape ();
        private var controller : Sprite;
        private var image : BitmapData;
        private var output : TextField;
        private var status : String;

        //

        private var CUR_CYCLE : Number = 0;
        private var NUM_CYCLE : uint = 8;

        private var VX : Number = 1.5;
        private var VD : Number = 1.0;
        private var _V : Number = 0;
        private var DG : Number = 0; 
        private var RD : Number;


        public function PAN_2_TEST ()
        {
            Wonderfl.disable_capture ();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {
                removeEventListener (Event.ADDED_TO_STAGE, init);
            }

            H = stage.stageHeight / 2;
            W = stage.stageWidth  / 2;

            stage.scaleMode = 'noScale';

            graphics.beginFill (0, 1);
            graphics.drawRect  (0, 0, W * 2, H * 2);

            //

            addChild (new Bitmap (image = new BitmapData (W*2, H*2, true, 0)));

            addChild (controller = new Sprite ());
            controller.graphics.beginFill (0xFFFFFF, 0.65);
            controller.graphics.drawCircle (0, 0, 5);
            controller.x = W;
            controller.y = H;

            addChild (output = new TextField ());
            output.textColor = 0x333333;
            output.autoSize = 'left';

            //

            sound = new Sound ();

            sound.addEventListener
            (
                Event.COMPLETE, setPlay
            );
            sound.addEventListener
            (
                IOErrorEvent.IO_ERROR, onIOError
            );
            sound.addEventListener
            (
                SecurityErrorEvent.SECURITY_ERROR, onSecurityError
            );

            sound.load (new URLRequest (URL), new SoundLoaderContext (1000, false));

            //

            chans = new SoundChannel ();

            trans = new SoundTransform (1, 0);
        }

        private function setPlay (e : Event) : void
        {
            chans = sound.play (0, 1000);

            setChannels (1, 1, 1, 1);

            stage.addEventListener (Event.ENTER_FRAME, setPanning);

            stage.addEventListener (MouseEvent.CLICK, setReset);
        }

        private function setPanning (e : Event) : void
        {
            RD = DG * (Math.PI / 180);

            controller.x = W + (_V * Math.cos (RD));
            controller.y = H + (_V * Math.sin (RD));

            //

            var L : Number = 1 - Math.abs ((controller.x - W) / W);
            var R : Number = 1 - Math.abs ((controller.y - H) / H);

            setChannels (L, L, R, R);

            //

            color.h = DG;

            lines.graphics.clear ();
            lines.graphics.lineStyle (1, color.value, L * R);
            lines.graphics.moveTo (W, H);
            lines.graphics.lineTo (controller.x, controller.y);

            image.draw (lines, null, null, 'normal');

            //

            _V += VX;
            DG -= VD;

            if (_V < 0 || _V > W)
            {
                VX = -VX;

                if ((CUR_CYCLE +=0.5) == NUM_CYCLE)
                {
                    stage.removeEventListener (Event.ENTER_FRAME, setPanning);
                }
            }

            //

            status = Math.floor(CUR_CYCLE)  + '  /  ' + NUM_CYCLE;

            output.text = 'PAN  LL / LR  |  ' + L.toFixed (2) + '  | RR / RL  |  ' + R.toFixed (2) + '  |  DRAW CYCLES  |  ' + status;
        }

        private function setChannels
        (
            LTL : Number = 1, LTR : Number = 0, RTR : Number = 1, RTL : Number = 0
        ) : void
        {
            trans.leftToLeft   = LTL;
            trans.leftToRight  = LTR;
            trans.rightToRight = RTR;
            trans.rightToLeft  = RTL;

            chans.soundTransform = trans;
        }
        
        private function setReset (e : MouseEvent) : void
        {
            image.fillRect (image.rect, 0);

            CUR_CYCLE = _V = DG = 0;

            VX = Math.abs (VX);

            if (!stage.hasEventListener (Event.ENTER_FRAME))
            {
                stage.addEventListener (Event.ENTER_FRAME, setPanning);
            }
        }

        // --o ERROR HANDLING

        private function onIOError (e : IOErrorEvent) : void {}
        
        private function onSecurityError (e : SecurityErrorEvent) : void {}
    }
}