/**
 * Copyright munku.jp ( http://wonderfl.net/user/munku.jp )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u3A0
 */

// forked from munku.jp's forked from: 重力マウス（参考にしていじってみました）
// forked from undo's 重力マウス
// Status() 追加
// fillRect から setPixel へ
// 三角関数除外（sin, cos, atn2）, 平方根除外（sqrt） ・・・ X,　Y の差分情報が有るので必要な処理は関数なで対応可能
// BitmapData をロックする。
// for ループを for each ループに変更 ・・・ パフォーマンスにはあまり影響は無さそう
// パーティクルを１０万個に変更
// 重力を３倍に変更
// 計算域を画面境界＋１００ピクセルに変更してパーティクルが画面の端から端に移動する空間を広げた。（画面の端からはみ出たパーティクルの回帰を遅らせたてみた）
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    [SWF(frameRate='60', width='465', height='465', backgroundColor='0x0')]

    public class ParticleTest1 extends Sprite
    {
        private var _bmp:Bitmap;
        private var _bmd:BitmapData;
        private var _bmdRect:Rectangle;
        private var _colorTransform:ColorTransform = new ColorTransform( 0.9, 0.9, 0.9, 1 );
        private var _redV:int = 1;
        private var _greenV:int = 1;
        private var _blueV:int = 1;

        private var _nodeArray:Array = [];
        private const _maxNum:int = 100000;

        private const _minBoundary:int = -100;
        private const _maxBoundary:int = 465 + 100;

        public function ParticleTest1()
        {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;

            addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);

            _bmd = new BitmapData(465, 465, false, 0x000000);
            _bmp = new Bitmap(_bmd);
            addChild(_bmp);
            this._bmdRect = new Rectangle(0, 0, 465, 465);

            for (var i:int = 0; i < this._maxNum; i++)
            {
                var n:Node = new Node();
                n.pX = Math.random() * 465;
                n.pY = Math.random() * 465;
                this._nodeArray.push(n);
            }

            addChild(new Stats());
            addEventListener(Event.ENTER_FRAME, onEnter);
        }

        private function onEnter(evt:Event):void
        {
//            var gravPoint:Point = new Point(mouseX, mouseY);
            var gravPointX:uint = mouseX;
            var gravPointY:uint = mouseY;

            this._bmd.lock();
//            for (var i:int = 0; i < this._maxNum; i++)
            for each( var n:Node in this._nodeArray )
            {
//                var n:Node = this._nodeArray[i] as Node;
/*
                var diff:Point = new Point(gravPoint.x - n.pos.x, gravPoint.y - n.pos.y);
                var rad:Number = Math.atan2(diff.y, diff.x);
                var grav:Number = 10 / Math.sqrt(diff.x * diff.x + diff.y * diff.y);
                n.acc.x = (Math.cos(rad) * grav);
                n.acc.y = (Math.sin(rad) * grav);
                n.v.x += n.acc.x;
                n.v.y += n.acc.y;
                n.pos.x += n.v.x;
                n.pos.y += n.v.y;

                n.acc.x *= 0.98;
                n.acc.y *= 0.98;
                n.v.x *= 0.96;
                n.v.y *= 0.96;
*/

                var diffX:Number = gravPointX - n.pX;
                var diffY:Number = gravPointY - n.pY;

                var gravD:Number = 30 / ( diffX * diffX + diffY * diffY );

                n.vX += diffX * gravD;
                n.vY += diffY * gravD;

                n.pX += n.vX;
                n.pY += n.vY;

                n.vX *= 0.96;
                n.vY *= 0.96;

                if (n.pX > _maxBoundary)
                    n.pX = _minBoundary;
                else if (n.pX < _minBoundary)
                    n.pX = _maxBoundary;
                if (n.pY > _maxBoundary)
                    n.pY = _minBoundary;
                else if (n.pY < _minBoundary)
                    n.pY = _maxBoundary;

//                this._bmd.fillRect(new Rectangle(n.pos.x, n.pos.y, 1, 1), 0xffffff);
                this._bmd.setPixel(n.pX, n.pY, 0xffffff );
            }

            if( Math.random() < 0.1 )
                ModifyColor();

            this._bmd.colorTransform(this._bmdRect, this._colorTransform);
            this._bmd.unlock();
        }

        private function ModifyColor():void
        {
            if( Math.random() < 0.03 )
            {
                this._redV = Math.random() * 3 - 1;
                this._greenV = Math.random() * 3 - 1;
                this._blueV = Math.random() * 3 - 1;
            }

            this._colorTransform.redMultiplier += this._redV * 0.01;
            if( this._colorTransform.redMultiplier < 0 || this._colorTransform.redMultiplier > 1.0 )
            {
                this._colorTransform.redMultiplier -= this._redV * 0.01;
                this._redV *= -1;
            }

            this._colorTransform.greenMultiplier += this._greenV * 0.01;
            if( this._colorTransform.greenMultiplier < 0 || this._colorTransform.greenMultiplier > 1.0 )
            {
                this._colorTransform.greenMultiplier -= this._greenV * 0.01;
                this._greenV *= -1;
            }

            this._colorTransform.blueMultiplier += this._blueV * 0.01;
            if( this._colorTransform.blueMultiplier < 0 || this._colorTransform.blueMultiplier > 1.0 )
            {
                this._colorTransform.blueMultiplier -= this._blueV * 0.01;
                this._blueV *= -1;
            }

        }

    }
}

class Node
{
    public var vX:Number;
    public var vY:Number;
    public var pX:Number;
    public var pY:Number;

    public function Node()
    {
        this.vX = this.vY = 0;
    }

}

/*
import flash.geom.Point;

class Node
{
    public var acc:Point;
    public var v:Point;
    public var pos:Point;

    public function Node()
    {
        this.acc = new Point();
        this.v = new Point();
        this.pos = new Point();
    }
}
*/