/**
 * Copyright Thy ( http://wonderfl.net/user/Thy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/u2Vq
 */

// forked from Thy's Eletric field 2
// forked from Thy's Eletric field 1
package 
{
    import flash.ui.Mouse;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    /**
     * ...
     * @author Thi
     * 
     * Color    :     Eletric field direction
     * green    :     up
     * black    :     down
     * blue     :     left
     * red      :     right
     * white    :     equilibrium
     * 
     */
    public class Main extends Sprite 
    {
        //
        private var eles:Vector.<Ele> = new Vector.<Ele>()
        private var usedXY:Vector.<Number>
        
        //
        private var i:int, l:int // l = length
        private var j:int, k:int
        
        //
        private var field_data:BitmapData = new BitmapData(465, 465, false, 0xA0A0A0)
        private var field_bitmap:Bitmap = new Bitmap(field_data, "auto", true)
        private var field_data2:BitmapData = new BitmapData(465, 465, false, 0xA0A0A0)
        private var field_bitmap2:Bitmap = new Bitmap(field_data2, "auto",true)
        private var rect:Rectangle = new Rectangle(0,0,465,465) 
        
        //
        private var itensity:int
        private var dx:Number, dy:Number
        
        //
        private var scale:Number, scale_inv:Number
        private var str:Number
        
        // 
        private var tf_sinal:TextField
        private var tf_field:TextField
        private var tf_scale_static:TextField
        private var tf_scale:TextField
        private var tf_str_static:TextField
        private var tf_str:TextField     
        
        
                  
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.frameRate = 40
            //
            this.addChild(field_bitmap)
            this.addChild(field_bitmap2)
            field_bitmap2.blendMode = BlendMode.SCREEN
            // text
            var format:TextFormat =  new TextFormat("Arial", 20,null,null,null,null,null,null,TextFormatAlign.CENTER)
            var t:TextField
            
            tf_sinal = new TextField()
            t = tf_sinal
            this.addChild(t)
            t.defaultTextFormat = format
            t.text = "+"; t.type = "dynamic"
            t.width = 40; t.height = 20
            t.selectable = false; t.border = true; 
            t.backgroundColor = 0xFFFFFF; t.background = true
            //
            format.size = 14
            tf_field = new TextField()
            t = tf_field
            this.addChild(t)
            t.defaultTextFormat = format
            t.text = "itensity shape"; t.type = "dynamic"
            t.width = 100; t.height = 20
            t.selectable = false; t.border = true;
            t.backgroundColor = 0xFFFFFF; t.background = true
            t.x = 365
            //
            format.align = TextFormatAlign.LEFT
            format.size = 14
            tf_scale_static = new TextField()
            t = tf_scale_static
            this.addChild(t)
            t.defaultTextFormat = format
            t.text = "scale ="; t.type = "dynamic"
            t.width = 70; t.height = 20
            t.selectable = false; t.border = false; 
            t.backgroundColor = 0xFFFFFF; t.background = false
            t.x = 60
            //
            format.size = 14
            tf_scale = new TextField()
            t = tf_scale
            this.addChild(t)
            t.defaultTextFormat = format
            t.text = "31"; t.type = "input"
            t.width = 60; t.height = 20
            t.selectable = true; t.border = true; 
            t.backgroundColor = 0xFFFFFF; t.background = true
            t.x = 110
            //
            format.size = 14
            tf_str_static = new TextField()
            t = tf_str_static
            this.addChild(t)
            t.defaultTextFormat = format
            t.text = "strenght ="; t.type = "dynamic"
            t.width = 80; t.height = 20
            t.selectable = false; t.border = false; 
            t.backgroundColor = 0xFFFFFF; t.background = false
            t.x = 190
            //
            format.size = 14
            tf_str = new TextField()
            t = tf_str
            this.addChild(t)
            t.defaultTextFormat = format
            t.text = "200"/*String((Math.random()*255)>>0)*/; t.type = "input"
            t.width = 60; t.height = 20
            t.selectable = true; t.border = true; 
            t.backgroundColor = 0xFFFFFF; t.background = true
            t.x = 270
            
            //
            vector = new Shape()
            addChild(vector)
            vector.blendMode = BlendMode.INVERT
            // listener
            stage.addEventListener(MouseEvent.CLICK, click)
            stage.addEventListener(Event.ENTER_FRAME, ef)
        }
        
        
        private function click(e:MouseEvent):void
        {
            if (mouseY > 20)
            {
                str = Number(tf_str.text)
                if(Number(str))
                {
                    ++l
                    eles.push(new Ele(mouseX, mouseY, tf_sinal.text == "+" ? str : -str))
                    // draw magnetic field
                    scale = Number(tf_scale.text)
                
                    if(Number(scale)) 
                    scale_inv = 1/scale,
                    field_data.lock(), field(), field_data.unlock();
                    Mouse.hide()
                }

                
            } else
            {
                if(mouseX <= 40)
                {
                    tf_sinal.text = tf_sinal.text == "+" ? "-" : "+"
                }
                else if (mouseX >= 365)
                {
                    field_bitmap2.visible = !field_bitmap2.visible
                }

                
            }
        }
        
        private function field():void
        {
            var X:Number, Y:Number, D:Number, 
            itensity:Number, itensity2:Number
            //
            usedXY = null
            usedXY = new Vector.<Number>(l * 2, true)
            field_data2.fillRect(rect, 0) 
            //
            i = -1
            while (++i < l)
            {
                // setup the x distance
                usedXY[int(i * 2)] = eles[i].x * scale_inv
                // setup the y distance
                usedXY[int(i * 2 + 1)] = eles[i].y * scale_inv + scale_inv
            }
            
            j = -1
            while (++j < 465)
            {
                i = -1
                while (++i < l)
                {
                    // change the y distance
                    usedXY[int(i * 2 + 1)] -= scale_inv
                }
                k = -1
                while (++k < 465)
                {
                    X = 0
                    Y = 127
                    itensity = itensity2 = 0
                    i = -1
                    while (++i < l)
                    {
                        // setup the 'now' x and y distances
                        dx = usedXY[int(i * 2)] - scale_inv*k
                        dy = usedXY[int(i * 2 + 1)]
                        D = dx*dx + dy*dy
                        
                        itensity2 += itensity = eles[i].f / D
                        
                        X += itensity * dx
                        Y += itensity * dy
                    }
                    
                    X = int(X)
                    Y = int(Y)
                    
                    if((X < 8 && X > -8) && (Y < 135 && Y > 119))
                    {
                        if(X*X + (Y-127)*(Y-127) < 9)
                        {
                            X = 0xFFFFFF, Y = 0
                        } else
                        {
                            X = 0xA0A0A0, Y = 0
                        }

                        
                        

                        
                    } else
                    {
                        if(X < 0) X = (-X)<<16
                    
                        if(Y < 127)
                        {
                            if(Y < 0)
                            {
                                Y = 0
                            } else 
                            {
                                Y = Y >> 1
                            }
                        }
 
                        if(Y > 0)
                        {
                            if(Y > 255) Y = 255
                            Y = Y << 8
                        }
                    }
                    
                    if(itensity2 & 0xFF == 0xFF)
                    {
                        field_data2.setPixel(k, j, 0xFFFFFF)
                    }

                    
                    

                    
                    field_data.setPixel(k, j, uint(X | Y ))
                }
            }
        }
        
        private var vector:Shape, g:Graphics
        private function ef(e:Event):void
        {
            g =  vector.graphics
            g.clear()
            g.lineStyle(2,0xFFFFFF)
            //
            var X:Number = 0, Y:Number = 0, D:Number
             i = -1
            while (++i < l)
            {
                dx = (eles[i].x) - mouseX
                dy = (eles[i].y) - mouseY
                D = (dx*dx) + (dy*dy)
                if(eles[i].f > 0)
                {
                    X -= dx / D
                    Y -= dy / D
                } else
                {
                    X += dx / D
                    Y += dy / D
                } 
            }
            g.moveTo(mouseX, mouseY)
            g.lineTo(mouseX + X*2000,mouseY + Y*2000)
            
            
            
            
        }

        
    }
}

//package  
//{
    /**
     * ...
     * @author Thi
     */
    /*public*/ class Ele
    {
        public var x:Number, y:Number, f:int
        
        public function Ele(x:Number, y:Number, f:Number) 
        {
            this.x = x
            this.y = y
            this.f = f
        }
        
    }

//}