/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/txu9
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Brownian extends Sprite
    {
        public static const W:uint = 465;
        public static const H:uint = 465;
        
        private var lastMouseX:int = -1;
        private var lastMouseY:int = -1;
        private var bitmap:Bitmap = new Bitmap();
        
        public function Brownian()
        {
            super();
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            addEventListener(Event.ENTER_FRAME, enterFrame);
            addChild(bitmap);
            bitmap.bitmapData = new BitmapData(W, H, true);
        }
        
        private function mouseMove(event:MouseEvent):void
        {
            if(lastMouseX != -1 && lastMouseY != -1)
            {
                var dx:Number = lastMouseX - mouseX;
                var dy:Number = lastMouseY - mouseY;
                var speed:Number = Math.sqrt(dx * dx + dy * dy);
                var particle:Particle = new Particle(mouseX, mouseY, speed);
                addChild(particle);
            }
            lastMouseX = mouseX;
            lastMouseY = mouseY;
        }
        
        private function enterFrame(event:Event):void
        {
            var shape:Shape = new Shape();
            shape.graphics.beginFill(0xFFFFFF, 0.49);
            shape.graphics.drawRect(0, 0, W, H);
            bitmap.bitmapData.draw(shape, null, null, BlendMode.ERASE);
            bitmap.bitmapData.draw(this);
        }
    }
}

import flash.display.Shape;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.utils.Timer;
import __AS3__.vec.Vector;

internal class Particle extends Shape
{
    public static var list:Vector.<Particle> = new Vector.<Particle>();
    public var radius:Number = 0;
    public var color:uint = 0;
    
    private static const MAX_SPEED:Number = 1;
    private static const ACCELERATION:Number = 20;
    private static const DEALPHA:Number = 0.9999;
    
    private var targetSpeedX:Number = 0;
    private var targetSpeedY:Number = 0;
    
    private var speedX:Number = 0;
    private var speedY:Number = 0;
    
    private var timer:Timer = new Timer(1000);
    
    public function Particle(x:Number, y:Number, speed:Number):void
    {
        this.x = x;
        this.y = y;
        color = speed * 10000;
        radius = 0.5;
        
        graphics.beginFill(color, 1);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        
        addEventListener(Event.ENTER_FRAME, enterFrame);
        timer.addEventListener(TimerEvent.TIMER, changeSpeed);
        timer.start();
        changeSpeed();
        
        list.push(this);
    }
    
    private function enterFrame(event:Event):void
    {
        speedX += (targetSpeedX - speedX) / ACCELERATION;
        speedY += (targetSpeedY - speedY) / ACCELERATION;
        x += speedX;
        y += speedY;
        alpha *= DEALPHA;
        if(alpha < 0.05)
            destroy();
    }
    
    private function changeSpeed(... rest):void
    {
        targetSpeedX = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
        targetSpeedY = Math.random() * MAX_SPEED * 2 - MAX_SPEED;
    }
    
    private function destroy():void
    {
        timer.stop();
        timer.removeEventListener(TimerEvent.TIMER, changeSpeed);
        removeEventListener(Event.ENTER_FRAME, enterFrame);
        parent.removeChild(this);
        list.splice(list.indexOf(this), 1);
    }
}