/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/txs3
 */

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    public class FlashTest extends Sprite {
        
        private static const FLOORS:Array = [
            {filename: '6hBfFcY', x: -325, y: -268},
            {filename: 'QWZeRZt', x: -325, y: -267},
            {filename: 'HNFqtYy', x: -277, y: -78},
            {filename: 'rdeMXvu', x: -276, y: -95},
            {filename: 'gNcH5qP', x: -277, y: -103},
            {filename: 'fQb7od1', x: -281, y: -101},
            {filename: '8fUOy81', x: -280, y: -95}
        ];
        private static const TRANS:ColorMatrixFilter = new ColorMatrixFilter([
            0, 0, 0, 0, 255,
            0, 0, 0, 0, 255,
            0, 0, 0, 0, 255,
            -1, -1, -1, 0, 672
        ]);
        private static const CHECKIT:LoaderContext = new LoaderContext(true);
        private static const ORIGIN:Point = new Point();
        private static const DIM:Number = 0.125;
        private static const BRIGHT:Number = 0.75;
        
        private var floors:Array = [];
        private var current:int = 2;
        private var scene:Sprite = new Sprite();
        private var yaw:Sprite = new Sprite();
        private var building:Sprite = new Sprite();
        
        public function FlashTest() {
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, function (e:UncaughtErrorEvent):void { Wonderfl.log(e.error); });
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            for (var i:int = 0; i < FLOORS.length; i++) {
                addFloor(i);
            }
            
            scene.x = 232.5;
            scene.y = 232.5;
            scene.rotationX = -45;
            
            yaw.addChild(building);
            scene.addChild(yaw);
            addChild(scene);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, down);
            stage.addEventListener(MouseEvent.MOUSE_UP, up);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
        }
        
        private function addFloor(i:int):void {
            var b:Bitmap = new Bitmap();
            b.x = FLOORS[i].x;
            b.y = FLOORS[i].y;
            b.z = (i - 2) * -30;
            b.alpha = i == current ? BRIGHT : DIM;
            building.addChild(b);
            floors[i] = b;
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, function (e:Event):void {
                var src:BitmapData = (l.content as Bitmap).bitmapData;
                var bd:BitmapData = new BitmapData(src.width, src.height, true, 0x000000);
                bd.applyFilter(src, src.rect, ORIGIN, TRANS);
                b.bitmapData = bd;
            });
            l.load(new URLRequest('http://i.imgur.com/' + FLOORS[i].filename + '.gif'), CHECKIT);
        }
        
        private function down(e:MouseEvent):void {
            building.startDrag();
        }
        
        private function up(e:MouseEvent):void {
            building.stopDrag();
        }
        
        private function keyDown(e:KeyboardEvent):void {
            switch (e.keyCode) {
            case 33: // PgUp
                if (current >= FLOORS.length - 1) break;
                floors[current].alpha = DIM;
                current++;
                floors[current].alpha = BRIGHT;
                break;
            case 34: // PgDn
                if (current <= 0) break;
                floors[current].alpha = DIM
                current--;
                floors[current].alpha = BRIGHT;
                break;
            case 81: // Q
                yaw.rotation -= 3;
                break;
            case 69: // E
                yaw.rotation += 3;
                break;
            default:
                Wonderfl.log(e.keyCode);
                break;
            }
        }
        
    }
}