/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/twpt
 */

package {
    import flash.filters.DropShadowFilter;
    import flash.filters.BevelFilter;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="0x888888")]
    public class FlashTest extends Sprite {
        private var sun:Sprite;
        private var earth:Sprite;
        public function FlashTest() {
            // write as3 code here..
            sun = new Sprite();
            sun.graphics.beginFill(0xFFFF00);
            sun.graphics.drawCircle(0, 0, 40);
            sun.graphics.endFill();
            sun.filters = [new BlurFilter(32, 32)];
            
            earth = new Sprite();
            earth.graphics.beginFill(0x0000FF);
            earth.graphics.drawCircle(0, 0, 30);
            earth.graphics.endFill();
            earth.x = stage.stageWidth / 2;
            earth.y = stage.stageHeight / 2;
            earth.filters = [new BevelFilter(12, 225, 0x000000, 0, 0x003333, 0.5, 5, 5, 1), new DropShadowFilter()];
            
            addChild(earth);
            addChild(sun);
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            sun.x += (mouseX - sun.x) * 0.2;
            sun.y += (mouseY - sun.y) * 0.2;
            var dist:Number = Math.sqrt(Math.pow(sun.x - earth.x, 2) + Math.pow(sun.y - earth.y, 2));
            var angle:Number = Math.atan2((earth.y - sun.y) , (earth.x - sun.x)) / Math.PI * 180;
            earth.filters = [new BevelFilter(12, angle, 0x000000, 00, 0x333300, 0.5, 5, 5, 1), new DropShadowFilter(dist / 3, angle)];
        }

    }
}

