/**
 * Copyright daniwell ( http://wonderfl.net/user/daniwell )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tvI7
 */

/**
 * GAME :: パネルを反転させてくゲーム
 * 
 * クリックしたパネルとその上下左右のパネルが反転します。正式名称があるのかよく分かりませんが、よくあるあれです。
 */
package  
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;

	[SWF(backgroundColor = "0xededed", frameRate = "30", width = "465", height = "465")]
	public class Flip extends Sprite
	{
		// ヨコ×タテ（ランダム）
		private var num_w :uint = uint(Math.random() * 10 + 5);
		private var num_h :uint = num_w;
		
		private var mainSp:Sprite = new Sprite();
		private var panels:Vector.<Vector.<Panel>> = new Vector.<Vector.<Panel>>(num_h);
		
		public function Flip() 
		{
			for (var i:int = 0; i < num_h; i ++)
			{
				panels[i] = new Vector.<Panel>(num_w);
				
				for (var j:int = 0; j < num_w; j ++)
				{
					var p:Panel = new Panel();
					p.change(); if (Math.random() < 0.5) p.change();
					p.x = j * 20; p.y = i * 20;
					p.addEventListener(MouseEvent.CLICK, clickHandler);
					mainSp.addChild(p);
					
					panels[i][j] = p;
				}
			}
			mainSp.x = mainSp.y = (465 - mainSp.width) / 2; // center
			addChild(mainSp);
		}
		private function clickHandler(e:MouseEvent):void
		{
			var nx:int = e.target.x / 20;
			var ny:int = e.target.y / 20;
			
			panels[ny][nx].change();
			if (0 <= nx - 1)		panels[ny][nx - 1].change();
			if (nx + 1 < num_w)	panels[ny][nx + 1].change();
			if (0 <= ny - 1)		panels[ny - 1][nx].change();
			if (ny + 1 < num_h)	panels[ny + 1][nx].change();
		}
	}
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Sprite;
import flash.geom.Rectangle;

class Panel extends Sprite
{
	private var _flag:Boolean = false;
	private var _bmp :Bitmap  = new Bitmap(new BitmapData(20, 20, false, 0xededed));
	
	public function Panel()
	{
		_bmp.bitmapData.fillRect(new Rectangle(1, 1, 18, 18), 0x888888);
		addChild(_bmp);
		
		buttonMode = true;
	}
	public function change():void
	{
		_flag = ! _flag;
		if (_flag)	_bmp.bitmapData.fillRect(new Rectangle(3, 3, 14, 14), 0xffcc00);
		else			_bmp.bitmapData.fillRect(new Rectangle(3, 3, 14, 14), 0xffffff);
	}
}