/**
 * Copyright yusufsaad ( http://wonderfl.net/user/yusufsaad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tuza
 */

package  {
    
    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Clipping;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.primitives.Box;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    
    public class ClippingExample extends Sprite {
        
        private var rootContainer:Object3DContainer = new DistanceSortContainer();
        
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        
        private var viewBound:Sprite = new Sprite;
        
        public function ClippingExample() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            // Camera and view
           
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(viewBound);
            addChild(camera.diagram);
            
            // set position
        
            camera.rotationX = -132*Math.PI/180;
            camera.y = -1000;
            camera.z = 800;
            controller = new SimpleObjectController(stage, camera, 500);
            rootContainer.addChild(camera);
            
            // Objects
           
            
            var material:FillMaterial = new FillMaterial(0x33337F, 1, 1);
            
            var box1:Box = new Box(500, 500, 500, 8, 8, 8);
            box1.clipping = Clipping.BOUND_CULLING;
            box1.x = -900;
            box1.y = -400;
            box1.z = -600;
            box1.setMaterialToAllFaces(material);
            rootContainer.addChild(box1);
            
            var box2:Box = new Box(500, 500, 500, 8, 8, 8);
            box2.clipping = Clipping.FACE_CULLING;
            box2.x = -800;
            box2.y = 200;
            box2.z = 400;
            box2.setMaterialToAllFaces(material);
            rootContainer.addChild(box2);
            
            var box3:Box = new Box(500, 500, 500, 8, 8, 8);
            box3.clipping = Clipping.FACE_CLIPPING;
            box3.x = 800;
            box3.y = 200;
            box3.z = 400;
            box3.setMaterialToAllFaces(material);
            rootContainer.addChild(box3);
            
            onResize();
            
            // Event
            
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
        }
        
        private function onEnterFrame(e:Event):void {
            controller.update();
            camera.render();
        }
        
        private function onResize(e:Event = null):void {
            var field:Number = 0.6;
            
            camera.view.width = stage.stageWidth*field;
            camera.view.height = stage.stageHeight*field;
            camera.view.x = (stage.stageWidth - stage.stageWidth*field)/2;
            camera.view.y = (stage.stageHeight - stage.stageHeight*field)/2;
            
            viewBound.graphics.clear();
            viewBound.graphics.beginFill(0x000000, 0.65);
            viewBound.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            viewBound.graphics.lineStyle(0, 0x7F7F7F);
            viewBound.graphics.drawRect(camera.view.x, camera.view.y, camera.view.width, camera.view.height);
            viewBound.graphics.endFill();
        }
        
    }
}
