/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ttt4
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    public class Main extends Sprite
    {
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            Buffer.initContext(stage);
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            init();
        }
            
        public function init() :void
        {
            graphics.clear();
            graphics.beginFill(0x999999);
            graphics.drawRect(0, 0, 465, 465);  
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Buffer
{
    public static var CANVAS :Stage;
    public static var OUTPUT :Output;
    public static var BANNER :Banner;
    public static var BUTTON_TRANSITION :int;
    
    public static function initContext($canvas:Stage) :void
    {
        CANVAS = $canvas;
        OUTPUT = new Output("");
        BANNER = new Banner(0, 93*2);
        BUTTON_TRANSITION = 0;
        
        $canvas.addChild(OUTPUT);
        $canvas.addChild(BANNER);   
        
        OUTPUT.content = "GUI Concept #3\n----------------------\n\nMove your mouse over the banner to observe\nthe buttons ease their pitch into proper position\n\nAn attractive animation for your GUI upon interface initialization.\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nThe solution for this can be applied to any rotation direction of a display object\nand implements as follows within this example:\n\n> element.pitch -= ((element.pitch - (easeMargin))/reverseMagnitude)";
    }
    
    public static function initBannerButtons($banner:Banner) :void
    {
        if ($banner.getChildAt(BUTTON_TRANSITION) != null)
        {
            CANVAS.addEventListener(Event.ENTER_FRAME, BannerButton($banner.getChildAt(BUTTON_TRANSITION)).rotationTrans);
        }
    }
}

class Banner extends Sprite
{
    private var button :BannerButton;
    private var button2 :BannerButton;
    private var button3 :BannerButton;
    
    public function Banner($x:*, $y:*)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        x = $x;
        y = $y;
        button = new BannerButton(x+62, 0);
        button2 = new BannerButton(x+62+93+31, 0);
        button3 = new BannerButton(x+62+93+31+93+31, 0);
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(button);
        addChild(button2);
        addChild(button3);
        
        init();
        
        addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }

    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0xCCCCCC);
        graphics.drawRect(0, 0, 465, 93);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        Buffer.initBannerButtons(this);
        removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
}

class BannerButton extends Sprite
{
    public function BannerButton($x:*, $y:*)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);    
        
        x = $x;
        y = $y;
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        rotationX += 98;
        
        init();
        
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        Buffer.CANVAS.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.beginFill(0xFFFFFF);
        graphics.drawRect(0, 31, 93, 31);
    }
    
    public function rotationTrans($e:*) :void
    {
        if (rotationX > 0)
        {
            rotationX -= int((rotationX - (-4))/3);
        }else{
            Buffer.BUTTON_TRANSITION++;
            Buffer.initBannerButtons(Banner(parent));
            Buffer.CANVAS.removeEventListener(Event.ENTER_FRAME, rotationTrans);           
        }
    }
    
    public function onMouseOver($e:MouseEvent) :void
    {
        alpha = 0.5;
    }
    
    public function onMouseOut($e:MouseEvent) :void
    {
        alpha = 1;
    }
}

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 3, $y:Number = 1, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
        
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font, null, 0xFFFFFF);
        setTextFormat(textFormat);
    }
        
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _init(); 
    }
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
}