/**
 * Copyright iong ( http://wonderfl.net/user/iong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ttgr
 */

/*
 thumbnail click -> display lerge image
*/
package {
    import flash.text.TextField;
    import flash.net.URLRequest;
    import flash.net.URLLoader;
    import flash.system.LoaderContext;  
    import flash.system.Security;

    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;  
    import flash.display.Graphics;
    import flash.display.BlendMode;

    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(width="465",height="465",backgroundColor="#ffffff",frameRate="30")]

    public class MediaRSSReader extends Sprite {
        private var _feed:String="http://api.flickr.com/services/feeds/photos_public.gne?tags=kamakura&format=rss_200";
        private var media:Namespace=new Namespace("http://search.yahoo.com/mrss/");

//        private var aryImgZ:Array = new Array("", "_b");
        private var aryObj:Array  = new Array();

        private var _bgd:BitmapData;
        private var _bg:Bitmap;
        private var _bgF:Sprite;
        private var isDisp:Boolean = false;
        private var frmImg:Sprite = new Sprite();
        private var frmImgEff:Sprite;

        // particle size
        private var iEW:uint = 10;
        private var iEH:uint = 80;

        private var actTarget:Bitmap;
        private var loaderImg:Loader;
        private var LC:LoaderContext;
        private var cR:Rectangle;
        private var pW:uint;
        private var pH:uint;
        private var pCnt:uint;
        private var pCntAll:uint;
        private var aryP:Array = new Array();

        private var container:Sprite=new Sprite();

        private var txt:TextField = new TextField();
        private var isDebug:Boolean = false;

        public function MediaRSSReader() {

            if(isDebug)debug();
            initBg();
            
            Security.loadPolicyFile("http://farm5.static.flickr.com/crossdomain.xml");
            LC= new LoaderContext(true);

            var ldr:URLLoader=new URLLoader  ;
            ldr.addEventListener(Event.COMPLETE, function _load(e:Event):void {;
            ldr.removeEventListener(Event.COMPLETE, _load);
            onImageLoaded(XML(ldr.data)..media::thumbnail.@url.toXMLString().split('\n'));
            });
            ldr.load(new URLRequest(_feed));
        }
        
        private function debug():void
        {
            addChild(txt);
            txt.width= stage.stageWidth;
            txt.height = stage.stageHeight;
            txt.text = "begin";
        }


        private function onImageLoaded($images:Array):void {
            var ldr:Loader;
            var btn:Sprite; var iX:uint; var iY:uint;
            for (var i:int = 0; i < $images.length; ++i) {
                ldr=new Loader  ;
                ldr.load(new URLRequest($images[i]));
                iX = (i % 5);
                iY = Math.floor(i/5);

                initBtn(btn=new Sprite(), ldr, $images[i], iX, iY);
                setBtn(btn);
                container.addChild(btn);
            }
            container.x=container.y=15;
            addChild(container);
        }

        private function initBg():void
        {
            _bgd  = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
            _bg   = new Bitmap(_bgd);
            _bgF  = new Sprite();
            with(_bgF.graphics){
                beginFill(0x000000, 0.75);
                moveTo(0,0);
                lineTo(0,stage.stageHeight);
                lineTo(stage.stageWidth,stage.stageHeight);
                lineTo(stage.stageWidth,0);
                endFill();
            }
            _bgF.addEventListener(MouseEvent.CLICK, bgFClick);
        }

        private function initBtn(sp:Sprite, _img:Loader, _url:String, iX:uint, iY:uint):void
        {
            sp.name = 'img'+iX+"_"+iY;
            sp.addChild(_img);
            sp.x = iX * 85;
            sp.y = iY * 85;

            if(!aryObj[iX]) aryObj[iX] = new Array();
            aryObj[iX][iY] = new Object();
            aryObj[iX][iY] = {
                 cnt: iX+iY
                ,iz:1
                ,izn:1
                ,url: _url
                ,prvW: 85
                ,prvH: 85
                ,prvX: sp.x
                ,prvY: sp.y
            };
        }

        private function setBtn(sp:Sprite):void
        {
            sp.buttonMode = true;
            sp.addEventListener(MouseEvent.MOUSE_OVER, btnOver);
            sp.addEventListener(MouseEvent.MOUSE_OUT, btnOut);
            sp.addEventListener(MouseEvent.CLICK, btnClick);
        }

        private function btnOver(e:MouseEvent):void
        {
            var sp:Sprite = e.target.parent;
            var iX:uint = Number(sp.name.substr(3).split("_")[0]);
            var iY:uint = Number(sp.name.split("_")[1]);

            aryObj[iX][iY].prvW = e.target.width;
            aryObj[iX][iY].prvH = e.target.height;
            aryObj[iX][iY].iz   = 1.1;
            sp.addEventListener(Event.ENTER_FRAME, btnZoom);
        }
        private function btnOut(e:MouseEvent):void
        {
            var sp:Sprite = e.target.parent;
            var iX:uint = Number(sp.name.substr(3).split("_")[0]);
            var iY:uint = Number(sp.name.split("_")[1]);

            aryObj[iX][iY].prvW = e.target.width;
            aryObj[iX][iY].prvH = e.target.height;
            aryObj[iX][iY].iz   = 1;
            sp.addEventListener(Event.ENTER_FRAME, btnZoom);
        }
        private function btnZoom(e:Event):void
        {
            var iX:uint = Number(e.target.name.substr(3).split("_")[0]);
            var iY:uint = Number(e.target.name.split("_")[1]);

            aryObj[iX][iY].izn += Math.round(aryObj[iX][iY].iz*100 - e.target.scaleX*100)/100*0.4;
            e.target.scaleX = e.target.scaleY = aryObj[iX][iY].izn;
            if(Math.abs(aryObj[iX][iY].iz-e.target.scaleX)<0.05){
                e.target.removeEventListener(Event.ENTER_FRAME, btnZoom);
                e.target.scaleX = e.target.scaleY = aryObj[iX][iY].iz;
            }
            e.target.x = aryObj[iX][iY].prvX - (e.target.width-aryObj[iX][iY].prvW)/2;
            e.target.y = aryObj[iX][iY].prvY - (e.target.height-aryObj[iX][iY].prvH)/2;
        }

        private function btnClick(e:MouseEvent):void
        {
            if(isDebug){
                txt.appendText("\n"
                +"click");
            }

            var sp:Sprite = e.target.parent;
            var iX:uint = Number(sp.name.substr(3).split("_")[0]);
            var iY:uint = Number(sp.name.split("_")[1]);

            dispImg(true, aryObj[iX][iY]);
        }

        private function bgFClick(e:MouseEvent):void
        {
            e.target.parent.dispImg(false, new Object());
        }

        private function dispImg(flg:Boolean, _obj:Object):void
        {
            if(isDebug){
                txt.appendText("\n"
                +"dispImg"+"\n"
                +(flg));
            }

            if(flg){
                if(isDebug){
                    txt.appendText("\n"
                    +_obj.url.split("_s").join(""));
                }

                isDisp = false;
                _bgd.draw(stage);
                addChild(_bg);
                addChild(_bgF);
                addChild(frmImg);
                removeChild(container);

                frmImgEff = new Sprite();
                frmImg.addChild(frmImgEff);

                loadImg(_obj.url.split("_s").join(""));

            }else if(isDisp){
                addChild(container);
                removeChild(frmImg);
                removeChild(_bg);
                removeChild(_bgF);
                if(frmImg.getChildByName(actTarget.name)!=null){
                    frmImg.removeChild(actTarget);
                    if(actTarget.hasEventListener(Event.ENTER_FRAME))
                        actTarget.removeEventListener(Event.ENTER_FRAME, chgImgGroup);
                }
                if(frmImg.getChildByName(frmImgEff.name)!=null){
                    frmImg.removeChild(frmImgEff);
                    for(var i:* in aryP){
                        for(var k:* in aryP[i]){
                            if(aryP[i][k].hasEventListener(Event.ENTER_FRAME))
                                aryP[i][k].removeEventListener(Event.ENTER_FRAME, chgImgPiece);
                        }
                    }
                    frmImgEff = new Sprite();
                }
            }
        }

        // load large image
        private function loadImg(url:String):void
        {
            if(isDebug){
                txt.appendText("\n"
                +"loadImg");
            }
            loaderImg = new Loader();
            loaderImg.contentLoaderInfo.addEventListener(Event.COMPLETE, imgLC);
            loaderImg.load(new URLRequest(url), LC);
        }

        private function imgLC(e:Event):void
        {
            if(isDebug){
                txt.appendText("\n"
                +"comp");
            }
            actTarget = initLCImg(e);
            actTarget.x += (stage.stageWidth-actTarget.width)/2;
            actTarget.y += (stage.stageHeight-actTarget.height)/2;

            cR = new Rectangle(0, 0, actTarget.width, actTarget.height);
            pW = Math.ceil(actTarget.width/iEW);
            pH = Math.ceil(actTarget.height/iEH);

            pCnt = 0;
            isDisp = true;
            actTarget.addEventListener(Event.ENTER_FRAME, chgImgGroup);
        }
        private function initLCImg(e:Event):Bitmap
        {
            var tmpL:LoaderInfo = e.currentTarget as LoaderInfo;
            var target:Loader   = tmpL.loader;
            var imgData:BitmapData = new BitmapData(target.width, target.height);
            imgData.draw(target);

            return new Bitmap(imgData);
        }

        private function chgImgGroup(e:Event):void
        {
            if(pW>pCnt){
                makeImg();
                for(var i:int=0; i<aryP[pCnt].length; i++){
                    var target:Sprite = Sprite(frmImgEff.getChildByName("p"+pCnt+"_"+i));
                    target.addEventListener(Event.ENTER_FRAME, chgImgPiece);
                }
                pCnt++;

            }else{
                if(pCntAll==0){
                    e.target.removeEventListener(Event.ENTER_FRAME, chgImgGroup);
                    frmImg.removeChild(frmImgEff);
                    frmImg.addChild(e.target as Bitmap);
                }
            }
        }

        private function makeImg():void
        {
            var tmpAry:Array = new Array();
            var iH:uint;

            aryP[pCnt]= new Array();
            for(var i:int=0; i<pH; i++){
                tmpAry.push(i);
            }
            var mi:uint = tmpAry.length;

            var flgE:Boolean = false;
            for(i=0; i<mi; i++){
                var tC:uint = i;
                iH = tmpAry[tC];
                var cM:Matrix   = new Matrix();
                cM.translate(-iEW*pCnt, -iEH*iH);
                var cB:BitmapData= new BitmapData(iEW+1, iEH+1, true, 0x000000);
                cB.draw(actTarget, cM, null, null, cR, true);
                var efS:Sprite = new Particle(cB, i, actTarget.x+iEW*pCnt, actTarget.y+iEH*iH);
                efS.name = "p"+pCnt+"_"+i;
                efS.alpha = 0;
                frmImgEff.addChild(efS);
                aryP[pCnt].push(efS);
                pCntAll++;
            }
        }

        private function chgImgPiece(e:Event):void
        {
            if(e.target.cnt<=0){
                e.target.alpha += 0.05;
                e.target.x += (e.target.ex-e.target.x)*.2;
                if(e.target.alpha>=1 && e.target.x-e.target.ex<0.5){
                    e.target.alpha = 1;
                    e.target.x     = e.target.ex;
                    e.target.removeEventListener(Event.ENTER_FRAME, chgImgPiece);
                    pCntAll--;
                }
            }else{
                e.target.cnt--;
            }
        }
    }
}
import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
class Particle extends Sprite
{
    public var cnt:uint;
    public var ex:int;

    function Particle(cB:BitmapData, i:uint, x:int, y:int):void
    {
        addChild(new Bitmap(cB));
        this.cnt = i;
        this.ex  = x;
        this.x   = this.ex + 100;
        this.y   = y;
    }
}
