/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ttaI
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    
    [SWF(frameRate=60, width=460, height=460)]
    public class Main extends Sprite
    {
        protected var _drawX :int;
        protected var _drawY :int;
        protected var _drawWidth :int;
        protected var _drawHeight :int;
        
        private var _displayOutput :Output;
        
        private var _prevMouse :Point = new Point();
        private var _thisMouse :Point = new Point();
        private var _calcMouse :Point = new Point();
        
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            _drawX = -1;
            _drawY = -1;
            _drawWidth = 0;
            _drawHeight = 0;
            _displayOutput = new Output("");
        }
        
        public function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            addChild(_displayOutput);
            
            init();
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        }
        
        public function init() :void
        {
            graphics.clear();
            graphics.lineStyle(1);
            graphics.drawRect(0, 0, (460-1), (460-1));
            graphics.lineStyle(1, 0xCCCCCC);
            graphics.drawRect(20, 20, 420, 420);
            
            for (var $:int=0; $<20; $++)
            {
                graphics.moveTo((40 + (20*$)), 20);
                graphics.lineTo((40 + (20*$)), 440);
                graphics.moveTo(20, (40 + (20*$)));
                graphics.lineTo(440, (40 + (20*$)));
            }
            
            graphics.lineStyle(1);
            graphics.drawRect(_drawX, _drawY, _drawWidth, _drawHeight);
        }
        
        public function onMouseDown($e:MouseEvent) :void
        {
            _prevMouse = new Point($e.stageX, $e.stageY);
            
            drawX = parseDimensions(_prevMouse, 1).x;
            drawY = parseDimensions(_prevMouse, 1).y;
            
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        public function onMouseMove($e:MouseEvent) :void
        {
            _thisMouse = new Point($e.stageX, $e.stageY);
            _calcMouse = _thisMouse.subtract(_prevMouse);
            
            drawWidth = parseDimensions(_calcMouse, 2).x;
            drawHeight = parseDimensions(_calcMouse, 2).y;
        }
        
        public function onMouseUp($e:MouseEvent) :void
        {
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            addChild(new DrawRectangle(_drawX, _drawY, _drawWidth, _drawHeight));
            
            _drawWidth = _calcMouse.x = 0;
            _drawHeight = _calcMouse.y = 0;
        }
        
        public function parseDimensions($loc:Point, $type:int) :Point
        {
            var $tempLoc :Point = new Point();
            var $targetX :Array = [];
            var $targetY :Array = [];
            var $resultX :Array = [];
            var $resultY :Array = [];
            var $indexX :int = -1;
            var $indexY :int = -1;
            
            for (var $:int=0; $<18; $++)
            {
                $targetX.push(40 + ($*20));
                $targetY.push(40 + ($*20));
                
                $resultX.push(int(Math.abs($loc.x - $targetX[$])));
                $resultY.push(int(Math.abs($loc.y - $targetY[$])));
            }
            
            $tempLoc.x = Math.min.apply(null, $resultX);
            $tempLoc.y = Math.min.apply(null, $resultY);
            
            for (var $$:int=0; $$<20; $$++)
            {
                ($tempLoc.x == $resultX[$$]) ? $indexX = $$ : null;
                ($tempLoc.y == $resultY[$$]) ? $indexY = $$ : null;
            }
            
            _displayOutput.content = "X: " + $targetX[$indexX] + "\nY: " + $targetY[$indexY];
            
            return new Point($targetX[$indexX], $targetY[$indexY]);
        }
        
        public function get drawX() :Number
        {return _drawX}
        public function get drawY() :Number
        {return _drawY}
        public function get drawWidth() :Number
        {return _drawWidth}
        public function get drawHeight() :Number
        {return _drawHeight}
        
        public function set drawX($:Number) :void
        {_drawX = $; init()}
        public function set drawY($:Number) :void
        {_drawY = $; init()}
        public function set drawWidth($:Number) :void
        {_drawWidth = $; init()}
        public function set drawHeight($:Number) :void
        {_drawHeight = $; init()}
    }
}

class DrawRectangle extends Sprite
{
    protected var _x :int;
    protected var _y :int;
    protected var _width :int;
    protected var _height :int;
    
    public function DrawRectangle($x:int, $y:int, $width:int, $height:int)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _width = $width;
        _height = $height;
    }
    
    public function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        init();
    }
    
    public function init() :void
    {
        graphics.clear();
        graphics.lineStyle(1);
        graphics.drawRect(_x, _y, _width, _height);
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import flash.text.*;

class Output extends TextField
{
    private var textFormat :TextFormat;
        
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _content :String;
        
    public function Output($content:String, $x:Number = 1, $y:Number = 0, $font:String = "Helvetica")
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _x = $x;
        _y = $y;
        _font = $font;
        _content = $content;
            
        multiline = true;
        autoSize = "left";
        selectable = mouseEnabled = false;
        antiAliasType = AntiAliasType.ADVANCED;
    }
        
    public function _init() :void
    {
        x = _x;
        y = _y;
        text = _content;
            
        textFormat = new TextFormat(_font);
        setTextFormat(textFormat);
    }
        
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        _init(); 
    }
        
    public function get font() :String
    { return _font }
    public function get nWidth() :Number
    { return width }
        
    public function set font($:String) :void
    { _font = $; _init() }
    public function set content($:String) :void
    { _content = $; _init() }
}