/**
 * Copyright rafael1 ( http://wonderfl.net/user/rafael1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ttD6
 */

// forked from Fred_Flanders's flash on 2010-12-6
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    [SWF(width="512",height="384",frameRate="20")]
    public class HellCam extends Sprite
    {
        protected var __camera:Camera;
        protected var __video:Video;
        
        protected var __width:int;
        protected var __height:int;
        protected var __quality:Number;
        protected var __fps:Number;
        
        protected var __prevbuffer:BitmapData;
        protected var __buffer:BitmapData;
        
        protected var __finalBitmapData:BitmapData;
        protected var __dispBitmapData:BitmapData;
        protected var __display:Bitmap;
        protected var __point:Point;
        protected var __rect:Rectangle;
        
        protected var __fadeCT:ColorTransform;
        protected var __offsetMatrix:Matrix;
        
        protected var __blur:BlurFilter;
        protected var __displacement:DisplacementMapFilter;
        
        protected var __dispSeed:Number=0;
        protected var tfWarning:TextField;
     
        protected var __paletteR:Array = [0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xffff00,0xFFFF00,0xFFFF00,0xFFFF00,0xFFFF00,0xFFFF00,0xFFFF00,0xFFFF00,0xFFFF00,0xFFFF00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0];
        protected var __paletteG:Array = [];
        protected var __paletteB:Array = [];
                 
        public function HellCam(){

            init();
        }
        protected function init():void{            
            __quality = 0.75;
            if(stage!=null)    {
                stage.align = StageAlign.TOP_LEFT;
                stage.scaleMode = StageScaleMode.NO_SCALE;
                __width = stage.stageWidth*__quality;
                __height = stage.stageHeight*__quality;
            }            
            else
            {
                __width = 512*__quality;
                __height =384*__quality;
                
            }
            __fps=30;
            __point=new Point();
            __fadeCT = new ColorTransform(1,1,0,0);
            __offsetMatrix=new Matrix();
            __blur=new BlurFilter(0,0,0);
            __dispSeed=4;
            for(var i:int=0;i<255;i++){
                __paletteG[i]=0;
                __paletteB[i]=0;
            }            
            
            initCamera();
            initVideo();
            initBitmaps();
            __displacement = new DisplacementMapFilter(__dispBitmapData,__point,0xffff00,0xffff00,0xffff00,10);
            start();
        }
        protected function initCamera():void
        {
            var arr:Array = Camera.names;
            arr.push("0");
            var len:int=arr.length;
            var ypos:int=0;
            var i:int;
            var _container:Sprite = new Sprite();
            for(i=0;i<len;i++){
                var tf:TextField = new TextField();
                tf.defaultTextFormat=new TextFormat("_sans",10,0,false,false,false,null,null,TextFormatAlign.CENTER);
                tf.text=arr[i];
                tf.border=true;
                tf.background=true;
                tf.y=ypos;
                tf.selectable=false;
                tf.height=tf.textHeight+5;
                tf.addEventListener(MouseEvent.CLICK,handleClickWebcam,false,0,true);
                _container.addChild(tf);
                ypos+=tf.height+5;
                if(__camera==null){
                    __camera=Camera.getCamera(arr[i]);
                }
                if(__camera==null){
                    __camera=Camera.getCamera(i.toString());
                }
            }
            
            if(__camera!=null){
                __camera.setMode(__width,__height,__fps);
                
            }
            else{
                tfWarning=new TextField();
                tfWarning.autoSize=TextFieldAutoSize.LEFT;
                tfWarning.defaultTextFormat=new TextFormat("_sans");
                tfWarning.text="Could not initialize webcam";
                tfWarning.background=true;
                tfWarning.backgroundColor=0xFFFF00;
                tfWarning.x=100;
                tfWarning.y=100;
                addChild(tfWarning);
                addChild(_container);
            }
        }
        protected function handleClickWebcam(evt:Event):void{
            var tf:TextField = evt.currentTarget as TextField;
            var id:String = tf.text;
            
            __camera = Camera.getCamera(id);
            tfWarning.visible=__camera==null;
            if(__camera!=null)
            {
                if(__video==null)
                {
                    __video=new Video(__width,__height);
                }
                __video.attachCamera(__camera);
                
            }
        }
        protected function initVideo():void{
            __video = new Video(__width,__height);
            if(__camera!=null){
                __video.attachCamera(__camera);
            }
            
            addChild(__video);
            __video.alpha = .4;
            __video.scaleX = 1/__quality;
            __video.scaleY = 1/__quality;
        }
        protected function initBitmaps():void{
            __finalBitmapData = new BitmapData(__width,__height,false,0);
            __rect=__finalBitmapData.rect;
            __buffer = new BitmapData(__width,__height,true,0);
            __prevbuffer = new BitmapData(__width,__height,true,0);
            __dispBitmapData = new BitmapData(__width,__height,false,0);
            //applyNoise();
            __display = new Bitmap(__finalBitmapData,"auto",true);
            __display.scaleX=1/__quality;
            __display.scaleY=1/__quality;
            addChildAt(__display,0);
        }
        protected function applyNoise():void{
            __dispBitmapData.perlinNoise(24,32,4,__dispSeed,true,true,7);
            __dispSeed+=1;
            if(__dispSeed>1000)    {
                __dispSeed %= 1000;
            }
        }
        protected function start():void{
            addEventListener(Event.ENTER_FRAME,handleEnterFrame,false,0,true);
        }
        protected function handleEnterFrame(evt:Event):void{
            render();
        }
        protected function render():void{
            //__offsetMatrix.ty=-(Math.random()*2+4);
            //__offsetMatrix.tx=Math.random()*2-1;
            
            __finalBitmapData.lock();
            __buffer.draw(__video);
            __buffer.draw(__prevbuffer,__offsetMatrix,__fadeCT);
            //__buffer.applyFilter(__buffer,__rect,__point,__blur);
            //applyNoise();
            //__buffer.applyFilter(__buffer,__rect,__point,__displacement);
            __prevbuffer.copyPixels(__buffer,__rect,__point);
        
            
            __finalBitmapData.copyPixels(__buffer,__rect,__point);
            __finalBitmapData.paletteMap(__buffer,__rect,__point,__paletteR,__paletteG,__paletteB);
            
            __finalBitmapData.unlock();    
        }
    }
}