/**
 * Copyright yonatan ( http://wonderfl.net/user/yonatan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tt7i
 */

// forked from yonatan's forked from: flash on 2012-12-1
// forked from yonatan's flash on 2012-12-1
package {
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;

    public class main extends Sprite {
        private static const W:int = 465;
        private static const H:int = 465;
        private static const MAXX:int = W-1;
        private static const MAXY:int = H-1;
        private static const NUM_BALLS:int = 15;
        private var _bmd:BitmapData = new BitmapData(W, H, false, 0);
        private var _bmp:Bitmap = new Bitmap(_bmd);
        private var _balls:Vector.<Ball> = new Vector.<Ball>();

        function main():void {
            addChild(_bmp);
            addEventListener("enterFrame", frame);
        }

        private function frame(e:Event):void {
            for(var i:int=0; i<NUM_BALLS; i++) {
                var r:Number = i/NUM_BALLS*2*Math.PI;
                var x:Number = Math.sin(r*getTimer()/21000) * 200 + 232;
                var y:Number = Math.cos(r*getTimer()/22000) * 200 + 232;
                _balls[i] = new Ball(x, y);
            }
            _bmd.fillRect(_bmd.rect, 0);
            trace(mouseX, mouseY);
        }

        private function trace(sx:int, sy:int):void {
            var cache:Array = [];
            var cnt:int = _balls.length, i:int, x:int = sx, y:int = sy;
            var target:Number, v:Number;
            var b:Ball;
            var dir:int = 0;

            for(i=0, target=0; i<cnt; i++) {
                b = _balls[i];
                b.jump(x, y);
                target += 1/b.tdsq;
            }

            var max:int=5000;
            while(max--) {
                while((dir==0 && x==0) || (dir==1 && y==0) ||
                    (dir==2 && x==MAXX) || (dir==3 && y==MAXY)) dir = (dir+1) & 3;
                switch(dir) {
                    case 0: x--; break;
                    case 1: y--; break;
                    case 2: x++; break;
                    case 3: y++; break;
                }
                // if(cache[y << 10 | x]) break; // argh!!!
                for(i=0, v=0; i<cnt; i++) {
                    b = _balls[i]; 
                    switch(dir) {
                        case 0: b.tdsq = b.tdsq - b.tx - b.tx + 1; b.tx--; break;
                        case 1: b.tdsq = b.tdsq - b.ty - b.ty + 1; b.ty--; break;
                        case 2: b.tdsq = b.tdsq + b.tx + b.tx + 1; b.tx++; break;
                        case 3: b.tdsq = b.tdsq + b.ty + b.ty + 1; b.ty++; break;
                    } 
                    v += 1/b.tdsq;
                }

                if(v>target) {
                    dir--;
                    _bmd.setPixel(x, y, 0xffffff);
                } else {
                    dir++;
                    _bmd.setPixel(x, y, 0xff0000);
                }
                dir &= 3;
                cache[y << 10 | x] = v;
            }
        }
    }
}

class Ball {
    public var cx:int, cy:int;
    public var tdsq:int, tx:int, ty:int; // for tracing

    public function Ball(x:int, y:int) {
        cx = x;
        cy = y;
    }

    public function jump(x:int, y:int):void {
        tx = x - cx;
        ty = y - cy;
        tdsq = tx * tx + ty * ty;
    }
}