/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tt4o
 */

// forked from codefl's striped line
package {
    
    import flash.geom.Point
    import flash.display.Bitmap
    import flash.display.BitmapData
    import flash.display.Graphics
    import flash.display.Shape
    import flash.display.Sprite
    import flash.events.Event
    import flash.events.MouseEvent
    
    [SWF(width=465, height=465, backgroundColor=0xabcdef, frameRate=30)]
    public class FlashTest extends Sprite {
        
        private var canvas:Bitmap
        private var line:StripedLine
        
        public function FlashTest() {
            if(stage) init()
            else addEventListener("added", function(e:Event):void{init()})
        }
        
        private function init():void {
            canvas = addChild( new Bitmap ) as Bitmap
            canvas.bitmapData = new BitmapData( 465, 465, true, 0 )
            line = addChild( new StripedLine( 0, 0xFFFFFF, 20, 2 ) ) as StripedLine
            stage.addEventListener("mouseDown", md)
            stage.addEventListener("mouseUp", mu)
        }
        
        private function md(e:MouseEvent):void {
            line.start(e.stageX, e.stageY)
            stage.addEventListener("mouseMove", mm)
        }
        private function mu(e:MouseEvent):void {
            stage.removeEventListener("mouseMove", mm)
            canvas.bitmapData.draw( line )
            line.clear()
        }
        private function mm(e:MouseEvent):void {
            line.to(e.stageX, e.stageY)
        }
        
    }
    
}

////////////////////////////////////////////////////////////////////////////

import flash.display.Shape
import flash.geom.Point

internal class StripedLine extends Shape {
    
    private var color1:uint
    private var color2:uint
    private var colorWidth:Number
    private var thickness:Number
    
    private var prev:Position
    private var curr:Position
    private var curr_color:uint = 0x000000
    private var rest:Number = colorWidth
    
    private var startx:Number=NaN, starty:Number=NaN
    public function start(x:Number, y:Number):void {
        startx = x
        starty = y
        rest = colorWidth
    }
    
    public function StripedLine( color1:uint = 0, color2:uint = 0xFFFF00, colorWidth:Number = 20, thickness:Number = 12 ) {
        this.color1 = color1
        this.color2 = color2
        this.colorWidth = colorWidth
        this.thickness = thickness
    }
    
    public function to(tx:Number, ty:Number):void {
        if(isNaN(startx) == false){
            prev = new Position(startx-(tx-startx),starty-(ty-starty), startx,starty, thickness)
            curr = new Position(startx,starty, tx,ty, thickness)
            startx = NaN
            starty = NaN
        }else{
            prev = curr
            curr = new Position(prev.x,prev.y, tx,ty, thickness)
        }
        draw(prev, curr)
    }
    
    public function clear():void {
        graphics.clear()
    }
    
    private function draw(p0:Position, p1:Position):void {
        var d:Number = Math.sqrt( Math.pow(p1.x-p0.x,2) + Math.pow(p1.y-p0.y,2) )
        if(d <= rest){
            fill(p0, p1)
            rest -= d
        }else{
            var pt:Position = Position.interpolate(p0, p1, rest, thickness)
            fill(p0, pt)
            curr_color = curr_color==color1 ? color2 : color1
            rest = colorWidth
            draw(pt, p1)
        }
    }
    
    private function fill(p0:Position, p1:Position):void {
        graphics.beginFill(curr_color, 1)
        graphics.moveTo(p0.upper.x, p0.upper.y)
        graphics.lineTo(p0.lower.x, p0.lower.y)
        graphics.lineTo(p1.lower.x, p1.lower.y)
        graphics.lineTo(p1.upper.x, p1.upper.y)
        graphics.endFill()
    }
    
}

internal class Position {
    
    private var _x:Number, _y:Number
    private var _upper:Point, _lower:Point
    
    public function Position(prevx:Number,prevy:Number, x:Number,y:Number, thickness:Number) {
        _x = x
        _y = y
        
        var movement:Point = new Point(x - prevx , y - prevy)
        var normal:Point = new Point(movement.y, -movement.x)
        var factor:Number = 0.5 * thickness / normal.length
        normal.x *= factor
        normal.y *= factor
        
        _upper = new Point(x+normal.x, y+normal.y)
        _lower = new Point(x-normal.x, y-normal.y)
    }
    
    public function get upper():Point { return _upper }
    public function get lower():Point { return _lower }
    public function get x():Number { return _x }
    public function get y():Number { return _y }
    
    public static function interpolate(p0:Position, p1:Position, rest:Number, thickness:Number):Position {
        var movement:Point = new Point(p1.x - p0.x , p1.y - p0.y)
        var factor:Number = rest / movement.length
        movement.x *= factor
        movement.y *= factor
        var px:Number = p0.x + movement.x
        var py:Number = p0.y + movement.y
        
        var p:Position = new Position(p0.x,p0.y, px,py, thickness)
        return p
    }
    
}