/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/trEI
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;

	[SWF(framerate="30",width="480",height="480",backgroundColor="0x000000")]
	public class Practice09 extends Sprite{
		private var cur:Cursor;
		private var target:Point;
		private var lines:Vector.<Point>;
		
		public function Practice09() {
			cur = new Cursor();
			lines = new Vector.<Point>();
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
			stage.addEventListener(Event.ENTER_FRAME,onFrame);
		}
		
		private function onMouseMove(e:MouseEvent):void {
			target = new Point(e.stageX,e.stageY);
		}
		
		private function onFrame(e:Event):void {
			cur.updateVector(target);
			lines.push(cur.update());
			if (lines.length > 60) lines.shift();
			graphics.clear();
			for (var i:int = 0; i < lines.length; i++) {
				var width:Number = i ;
				var alpha:Number = i / lines.length;
				graphics.lineStyle(width, getColor(alpha), alpha);
				if (i == 0) {
					graphics.moveTo(lines[i].x,lines[i].y);
				}else {
					graphics.lineTo(lines[i].x,lines[i].y);
				}
			}
		}
		
		private function getColor(v:Number):Number {
			var r:Number = Math.cos(Math.PI * ((v - 0.81) * 1.1)) * 255;
			var g:Number = Math.cos(Math.PI * ((v - 0.50) * 1.0)) * 255;
			var b:Number = Math.cos(Math.PI * ((v - 0.19) * 1.1)) * 255;
			r = Math.min(255, r);
			r = Math.max(0, r);
			g = Math.min(255, g);
			g = Math.max(0, g);
			b = Math.min(255, b);
			b = Math.max(0, b);
			return (r<<16)+(g<<8)+b;
		}
	}

}
import flash.display.MovieClip;
import flash.geom.Point;

class Cursor {
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	
	public function Cursor():void {
		x = 0;
		y = 0;
		vx = 0;
		vy = 0;
	}
	
	public function updateVector(target:Point):void {
		var len:Number = Math.sqrt(Math.pow(target.x - x, 2) + Math.pow(target.y - y, 2));
		var vec:Number = Math.sqrt(len);
		var vvx:Number = (target.x - x) / len * vec;
		var vvy:Number = (target.y - y) / len * vec;
		vx = (vx + vvx) / 2;
		vy = (vy + vvy) / 2;
	}
	
	public function update():Point {
		x += vx;
		y += vy;
		return new Point(x, y);
	}
}