/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tqil
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.filters.*;
    
    [SWF(backgroundColor="#000000", frameRate="20")]
    
    public class FlashTest extends Sprite {
        private const H:Number = 465, W:Number = 465;
        private const T2:Number = 100.0, SR:Number = 18.3;
        private const A:Number = (1.0001 * W) / H;
        private const SY:Number = 2.0001 / H, SX:Number = 2.0001 / W;
        private const DY:Number = -30, DX:Number = A * DY;
        
        private const FadeOut:ColorTransform = new ColorTransform(1, 1, 1, 1, -15, -1, -5, 0);
        private const MixPixels:BlurFilter = new BlurFilter(2, 2, 2);
        private const Origin:Point = new Point(0, 0);
        private const StarCopyMatrix:Matrix = new Matrix(1, 0, 0, 1, (W + 1)*0.5, (H + 1) * 0.5);
        private const ScaleMatrix:Matrix = new Matrix(1 - SX * DX, 0, 0, 1 - SY * DY, DX /*hack: */-0.3, DY);
        private var T:Number = 0, starShineR:Number = 18;
        private var star:Sprite = new Sprite;
        private var starShine:Shape = new Shape;
        private var starMask:Shape = new Shape;
        private var starBitmap:Bitmap = new Bitmap;
        private var starBitmapData:BitmapData = new BitmapData(W, H, true, 0xff000000);
        private var starBitmapData2:BitmapData = new BitmapData(W, H, true);
        private var skyPatch:Sprite = new Sprite;
        private var skyStars:Shape = new Shape;
        private var skyColor:Shape = new Shape;
        
        public function FlashTest() {
            star.addChild(starShine); starShine.x = starShine.y = -20;
            star.addChild(starMask);
            starMask.graphics.beginFill(0); starMask.graphics.drawCircle(0, 0, 20); starMask.graphics.endFill();
            starShine.mask = starMask;
            starBitmap.bitmapData = starBitmapData;
            addChild(starBitmap); addChild(skyPatch);
            skyPatch.addChild(skyStars); drawStars();
            skyPatch.addChild(skyColor);
            skyColor.graphics.beginFill(0x1580); skyColor.graphics.drawRect(0, 0, W, H); skyColor.graphics.endFill();
            skyStars.alpha = skyColor.alpha = 0;
            skyColor.blendMode = "lighten";
            addEventListener("enterFrame", onEnterFrame);            
        }
        
        private function onEnterFrame(e:*):void {
            T++;
            
            var dX:Number = 0;
            if(T < T2) {
                dX = 20.5 / T2 * Math.sqrt(2) * (T2 - 1 - T);
            }
            
            if((T > T2 * 0.8) && (skyColor.alpha > 0)) {
                skyColor.alpha -= 4 / T2; skyStars.alpha += 6 / T2;
            }
            
            if(T > T2 * 0.95) {
                if(starShineR < SR) starShineR += 4 / T2;
            }
            
            starShine.graphics.clear();
            starShine.graphics.beginFill(0xffffff);
            starShine.graphics.drawCircle(20, 20, 20);
            starShine.graphics.drawCircle(20 + dX, 20 + 0.3 * dX, starShineR);
            starShine.graphics.endFill();
            
            var PassN:Number = 0;
            if(T == 1) {
                PassN = 40; skyColor.alpha = 1;
            } else if((T > T2 - 10) && (starShineR < SR)) {
                if(PassN < 30) PassN += 3;
            } else {
                PassN = 1;
            }
            
            for(var i:int = 0; i < PassN; i++) {
                starBitmapData.draw(star, StarCopyMatrix)
                starBitmapData2.applyFilter(starBitmapData, starBitmapData.rect, Origin, MixPixels);
                starBitmapData.draw(starBitmapData2, ScaleMatrix, FadeOut, "normal", starBitmapData.rect);
            }
        }
        
        private function drawStars():void {
            for(var z:int = 0; z < 100; z++) {
                var xp:Number = W * Math.random(), yp:Number = H * Math.random();
                var p:Point = new Point(xp - W / 2, yp - H / 2); if(p.length > 20 + 40) {
                    skyStars.graphics.lineStyle(1, 0x8f8fff, 50 + 50 * Math.random());
                    skyStars.graphics.moveTo(xp, yp); skyStars.graphics.lineTo(xp + 1, yp);
                }

            }

        }


    }
}