/**
 * Copyright ladeng6666 ( http://wonderfl.net/user/ladeng6666 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tqad
 */

// forked from ladeng6666's InnerBoundary
package  
{
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.net.URLRequest;
    /**
     * ...
     * @author ladeng6666
     */
    public class InnerBoundary extends Sprite
    {
        private var background:Loader;
        private var char:Head;
        
        private var vx:int = 0;
        private var vy:int = 0;
        private var speed:int = 10;
        
        private var charW:Number;
        private var charH:Number;
        
        private    var innerLeft:Number;
        private    var innerRight:Number;
        private    var innerTop:Number;
        private    var innerBtm:Number;
        public function InnerBoundary() 
        {
            init();
        }
        private function init():void {
            char = new Head();
            background = new Loader();
            background.load(new URLRequest("http://farm5.static.flickr.com/4125/4980972747_62aa959931_b.jpg"));
            background.contentLoaderInfo.addEventListener(Event.COMPLETE, onBGLoaded);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onStageKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onStageKeyUp);
            stage.addEventListener(Event.ENTER_FRAME, loop);
        }
        private function onBGLoaded(e:Event):void
        {
            charW = char.width;
            charH = char.height;
            
            innerLeft = 100;
            innerRight = stage.stageWidth - 100;
            innerTop = 100;
            innerBtm = stage.stageHeight - 100;
            
            addChild(background);
            addChild(char);
        }
        public function onStageKeyDown(ke:KeyboardEvent):void {
            switch (ke.keyCode) {
                case Keyboard.LEFT:
                    vx = -speed ;
                    break ;
                case Keyboard.RIGHT:
                    vx = speed;
                    break;
                case Keyboard.UP:
                    vy = -speed;
                    break;
                case Keyboard.DOWN:
                    vy = speed;
                    break;
            }
        }
        public function onStageKeyUp(ke:KeyboardEvent):void {
            switch (ke.keyCode) {
                case Keyboard.LEFT:
                case Keyboard.RIGHT:
                    vx = 0;
                    break;
                case Keyboard.UP:
                case Keyboard.DOWN:
                    vy = 0;
                    break;
            }            
        }
        private function loop(e:Event):void
        {
            char.x += vx;
            char.y += vy;
            
            if (char.x - charW / 2 < innerLeft) {
                char.x = innerLeft + charW / 2;
                background.x -= vx;
                innerRight = stage.stageWidth - 100;
            }else if (char.x + charW / 2 > innerRight) {
                background.x -= vx;
                char.x = innerRight - charW / 2;    
                innerLeft = 100;
            }
            if (char.y - charH / 2 < innerTop)
            {
                char.y = innerTop +charH / 2;
                background.y -= vy;
                innerBtm = stage.stageHeight - 100;
            }else if (char.y + charH / 2 > innerBtm)
            {
                char.y = innerBtm - charH / 2;
                background.y -= vy;
                innerTop = 100;
            }
            
            if (background.x >= 0) {
                background.x = 0;
                innerLeft = 0;
            }else if (background.x < stage.stageWidth -background.width) {
                background.x = stage.stageWidth -background.width
                innerRight  = stage.stageWidth;
            }
            if (background.y >= 0)
            {
                background.y = 0;
                innerTop = 0;
            }else if (background.y < stage.stageHeight - background.height)
            {
                background.y = stage.stageHeight - background.height;
                innerBtm = stage.stageHeight;
            }
            
        }
    }

}
import flash.display.Sprite
class Head extends Sprite  {
    public function Head():void {
        graphics.lineStyle(1);
        graphics.beginFill(0xff0000);
        graphics.drawCircle(0, 0, 25);
        graphics.endFill();
    }
}