/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tpQq
 */

// forked from Dorara's crashgame
// test
package {
	import flash.events.MouseEvent;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.text.TextField;
	
	import com.bit101.components.*;

	[SWF(backgroundColor=0x000000)]
	public class CrashGame extends Sprite
	{
		private var N:int = 100;
		private var nowN:int;
		private var balls:Array;
		private var balld:Array;
		private var car:Sprite;
		private var item:pData;
		private var items:Sprite;
		private var text_field:Label;
		private var score:int;
		private var highscore:int;
		private var resetbutton:PushButton;
		
		public function CrashGame()
		{
			this.stage.align = StageAlign.TOP_LEFT;
			this.stage.scaleMode = StageScaleMode.NO_SCALE;

			resetbutton = new PushButton(this, 350, 0, "Click", resetFunc);
			resetbutton.label = "Reset";
			resetbutton.width = 100;
			resetbutton.height = 20;
					
			score = 0;
			highscore = 0;
				
			text_field = new Label(this, 0, 0, "");
			text_field.width = 200;
			text_field.height = 20;
			text_field.text = " Score: 0(HighScore:0)";
			text_field.scaleX = text_field.scaleY = 2.0;
			addChild(text_field);
			
			nowN = 1;
			item = new pData();
			items = new Sprite();
			items.graphics.beginFill(0xcccccc);
			items.graphics.drawCircle(0, 0, 15);
			items.graphics.endFill();
			addChild(items);
			items.x = item.x;
			items.y = item.y;
			
			balls = new Array(N);
			balld = new Array(N);
			for(var i:int = 0; i < N; i++){
				var tmp:Sprite = new Sprite();
				var tmp2:bData = new bData();
				tmp.graphics.beginFill(0x0000ff);
				tmp.graphics.drawCircle(0, 0, 15);
				tmp.graphics.endFill();
				this.addChild(tmp);
				balls[i] = tmp;
				balld[i] = tmp2;
				
				balls[i].x = -30;
				balls[i].y = -30;
			}
			
			car = new Sprite();
			car.graphics.beginFill(0x333333);
			car.graphics.drawCircle(10,20,5);
			car.graphics.drawCircle(45,20,5);
			car.graphics.endFill();
			
			car.graphics.beginFill(0xff0000);
			car.graphics.moveTo(0,10);
			car.graphics.lineTo(15,0);
			car.graphics.lineTo(30,0);
			car.graphics.lineTo(40,10);
			car.graphics.lineTo(50,10);
			car.graphics.lineTo(55,15);
			car.graphics.lineTo(55,20);
			car.graphics.lineTo(0,20);
			car.graphics.endFill();	
			car.x = 255;
			car.y = 255;
			this.addChild(car);
	
			this.addEventListener(Event.ENTER_FRAME, _timerFunc);
		}
	
		public function resetFunc(e:MouseEvent):void {
			score = 0;
				
			text_field.text = " Score: 0"+ " (HighScore:" + String(highscore) + ")";
			
			nowN = 1;

			item.Update();
			items.x = item.x;
			items.y = item.y;
			
			for(var i:int = 0; i < N; i++){
				balld[i].reset();
				
				balls[i].x = -30;
				balls[i].y = -30;
			}
			this.addEventListener(Event.ENTER_FRAME, _timerFunc);
		}
		
		public function _timerFunc(e:Event):void{
			for(var i:int = 0; i < nowN; i++){
				balld[i].Update();
				balls[i].x = balld[i].x;
				balls[i].y = balld[i].y;
				//衝突判定
				if((stage.mouseX - balls[i].x) * (stage.mouseX - balls[i].x) + (stage.mouseY - balls[i].y) * (stage.mouseY - balls[i].y) < 900){
					this.removeEventListener(Event.ENTER_FRAME, _timerFunc);
					this.setChildIndex(text_field, this.numChildren-1);
					this.setChildIndex(resetbutton, this.numChildren-1);
					text_field.text = "Crash!!! Score is " + String(score) + " (HighScore:" + String(highscore) + ")";
					if(highscore < score) highscore = score;
				}
				if((stage.mouseX - item.x) * (stage.mouseX - item.x) + (stage.mouseY - item.y) * (stage.mouseY - item.y) < 900){
					item.Update();
					items.x = item.x;
					items.y = item.y;
					nowN++;
					if(nowN == 100){
						this.removeEventListener(Event.ENTER_FRAME, _timerFunc);
						this.setChildIndex(text_field, this.numChildren-1);
						text_field.text = "Great!!!All Clear! Score is " + String(score);
					}else{
						score += 10;
						text_field.text = " Score: " + String(score) + " (HighScore:" + String(highscore) + ")";
					}
				}
			}
			car.x = stage.mouseX;
			car.y = stage.mouseY;
		}
		
	}
}

class bData{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	
	public function bData(){
		x = Math.random() * 465;
		y = Math.random() * 465;
		vx = Math.random() * 10 - 5;
		vy = Math.random() * 10 - 5;
	}
	
	public function reset():void{
		x = Math.random() * 465;
		y = Math.random() * 465;
		vx = Math.random() * 10 - 5;
		vy = Math.random() * 10 - 5;
	}
	public function Update():void{
		x += vx;
		y += vy;
		
		if(x < 0 || x > 465){
			vx = -vx;
		}
		if(y < 0 || y > 465){
			vy = -vy;
		}
	}
}

class pData{
	public var x:Number;
	public var y:Number;
	
	public function pData(){
		x = Math.random() * 465;
		y = Math.random() * 465;
	}
	public function Update():void{
		x = Math.random() * 465;
		y = Math.random() * 465;
	}
}