/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tour
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
    public class FlashTest extends Sprite
	{
		private var bmpdata:BitmapData;
		private var bdView:BitmapData;
		private var seed:int;
		private var offsets:Array;
        public function FlashTest()
		{
			this.graphics.beginFill(0);
			this.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			bmpdata = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
			seed = Math.random() * 0xFFFFFFFF;
			offsets = new Array();
			for (var i:int = 0; i < 4; i++)
			{
				offsets[i]=new Point();
			}
			
			bdView = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0);
			addChild(new Bitmap(bmpdata));
			addChild(new Bitmap(bdView));
			
			stage.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
		
		private function enterFrameHandler(e:Event):void 
		{
			bmpdata.perlinNoise(bmpdata.width * .2, bmpdata.height * .2, 4, seed,
				false, true, 7, true, offsets);
			for (var i:int = 0; i < 4; i++)
			{
				offsets[i].x -= i+1;
				offsets[i].y += i+1;
			}
			bdView.lock();
			bdView.fillRect(bdView.rect, 0);
			var x:Number = 5, y:Number = 5;
			while (y < bdView.height)
			{
				while (x < bdView.width)
				{
					var color:uint = bmpdata.getPixel32(x + 15, y);
					bdView.fillRect(new Rectangle(x,y-2,30,2), color);
					color = bmpdata.getPixel32(x, y + 15);
					bdView.fillRect(new Rectangle(x-2,y,2,30), color);
					x += 30;
				}
				x = 5;
				y += 30;
			}
			bdView.unlock();
		}
    }
}