/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/to4O
 */

package 

{

    

    import com.bit101.components.CheckBox;

    import com.bit101.components.Label;

    import com.bit101.components.NumericStepper;

    import flash.display.Shape;

    import flash.display.Sprite;

    import flash.events.Event;

    /**

     * ...

     * @author umhr

     */

    public class Canvas extends Sprite 

    {

        private var _drawCanvas:Sprite = new Sprite();

        private var _ctrlCanvas:Sprite = new Sprite();

        private var _layerCount:int = 35;

        private var _lineAlpha:Number = 0.5;

        private var _isDrawLine:Boolean = true;

        private var _isDrawFill:Boolean = true;

        public function Canvas() 

        {

            init();

        }

        private function init():void 

        {

            if (stage) onInit();

            else addEventListener(Event.ADDED_TO_STAGE, onInit);

        }



        private function onInit(event:Event = null):void 

        {

            removeEventListener(Event.ADDED_TO_STAGE, onInit);

            // entry point

            

            graphics.beginFill(0xFFFFFF);

            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);

            graphics.endFill();

            

            addChild(_drawCanvas);

            addChild(_ctrlCanvas);

            addCtrl();

            draw();

        }

        

        private function addCtrl():void 

        {

            _ctrlCanvas.y = stage.stageHeight - 30;

            

            new Label(_ctrlCanvas, 16, 8, "Number of Shape");

            

            new NumericStepper(_ctrlCanvas, 100, 8, function(event:Event):void {

                var stepper:NumericStepper = event.currentTarget as NumericStepper;

                _layerCount = stepper.value;

                draw();

                }).value = _layerCount;

            

            new CheckBox(_ctrlCanvas, 200, 12, "Line Alpha", function(event:Event):void {

                var check:CheckBox = event.currentTarget as CheckBox;

                _lineAlpha = check.selected?0.5:1;

                draw();

                }).selected = true;

            new CheckBox(_ctrlCanvas, 280, 12, "Draw Line", function(event:Event):void {

                var check:CheckBox = event.currentTarget as CheckBox;

                _isDrawLine = check.selected;

                draw();

                }).selected = _isDrawLine;

            new CheckBox(_ctrlCanvas, 360, 12, "Draw Fill", function(event:Event):void {

                var check:CheckBox = event.currentTarget as CheckBox;

                _isDrawFill = check.selected;

                draw();

                }).selected = _isDrawFill;

        }

        

        private function draw():void 

        {

            _drawCanvas.removeChildren();

            

            var n:int = _layerCount;

            for (var i:int = 0; i < n; i++) 

            {

                var lineRGB:int = i % 10 == 0?0xFF0000:0x000000;

                var shape:Shape = new Shape();

                if(_isDrawLine){

                    shape.graphics.lineStyle(0, lineRGB, _lineAlpha);

                }

                if(_isDrawFill){

                    shape.graphics.beginFill(0x8888FF, 0.05);

                }

                shape.graphics.drawRect(0, 0, 300, 300);

                shape.graphics.endFill();

                _drawCanvas.addChild(shape);

                shape.x = i * 3;

                shape.y = i * 3;

            }

        }

    }

    

}