/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tnrj
 */

package {
    import flash.net.FileReference;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;
    
    import com.adobe.images.PNGEncoder;
    public class FlashTest extends Sprite {
        
        private static const s:Number = 10. / 0x4000;
        private static const c:Array = [0x828282, 0x919191];
        private static const a:Array = [1, 1];
        private static const r:Array = [0, 255];
        private static const m:Matrix = new Matrix(0, -24 * s, 1, 0, 0, 19);
        private static const f:DropShadowFilter = new DropShadowFilter(1, 90, 0xffffff, 0.1, 0, 0, 1, BitmapFilterQuality.LOW, true);
        private static const fl:DropShadowFilter = new DropShadowFilter(12, 90, 0xffffff, 0.1, 0, 0, 1, BitmapFilterQuality.LOW, true);
        
        private var sh:Shape;
        private var ba:ByteArray;
        
        public function FlashTest() {
            var cx:Number = 12;
            var cy:Number = 22;
            
            var g:Graphics = init();
            stroke(g, 2);
            arc(g, cx, cy, 11, 150, 330, false, 6);
            stroke(g, 3);
            arc(g, cx, cy, 10.5, 330, 390, false, 2);
            stroke(g, 1);
            for (var i:int = 5; i <= 13; i++) {
                var t:Number = i * 30;
                sincos(g, t, 12, cx, cy, false);
                sincos(g, t, 8, cx, cy, true);
            }
            g.lineStyle();
            fill(g);
            g.drawCircle(cx, cy, 2);
            g.endFill();
            fill(g);
            sincos(g, 210, 1.5, cx, cy, false);
            sincos(g, 300, 8, cx, cy, true);
            sincos(g, 30, 1.5, cx, cy, true);
            preview();
        }
        
        private function fill(g:Graphics):void {
            g.beginGradientFill(GradientType.LINEAR, c, a, r, m);
        }
        
        private function stroke(g:Graphics, thickness:Number=1):void {
            g.lineStyle(thickness, 0x000000, 1, false, LineScaleMode.NORMAL, CapsStyle.NONE, JointStyle.MITER, 4);
            g.lineGradientStyle(GradientType.LINEAR, c, a, r, m);
        }
        
        private function arc(g:Graphics, cx:Number, cy:Number, r:Number, t0:Number, t1:Number, c:Boolean=true, d:int=4):void {
            sincos(g, t0, r, cx, cy, c);
            var dt:Number = (t1 - t0) / d;
            var r2:Number = r / Math.cos(dt / 360 * Math.PI);
            for (var i:int = 0; i < d; i++) {
                var ta:Number = t0 + (i + 0.5) * dt;
                var tb:Number = t0 + (i + 1) * dt;
                g.curveTo(cos(ta, r2, cx), sin(ta, r2, cy), cos(tb, r, cx), sin(tb, r, cy));
            }
        }
        
        private function sincos(g:Graphics, deg:Number, r:Number, cx:Number, cy:Number, c:Boolean=false):void {
            (c ? g.lineTo : g.moveTo)(cos(deg, r, cx), sin(deg, r, cy));
        }
        
        private function cos(deg:Number, amp:Number=1, zero:Number=0):Number {
            return Math.cos(deg / 180 * Math.PI) * amp + zero;
        }
        
        private function sin(deg:Number, amp:Number=1, zero:Number=0):Number {
            return Math.sin(deg / 180 * Math.PI) * amp + zero;
        }
        
        private function init():Graphics {
            graphics.lineStyle(0, 0xe0e0e0);
            var i:int;
            for (i = 4; i <= 465; i += 12) {
                graphics.moveTo(i, 0);
                graphics.lineTo(i, 465);
                graphics.moveTo(0, i);
                graphics.lineTo(465, i);
            }
            graphics.lineStyle(0, 0xff0000);
            graphics.drawRect(88, 4, 288, 456);
            graphics.lineStyle(0, 0x0000ff);
            graphics.drawRect(88, 88, 288, 288);
            
            sh = new Shape();
            sh.scaleX = 12;
            sh.scaleY = 12;
            sh.x = 88;
            sh.y = 4;
            sh.filters = [f];
            addChild(sh);
            
            stage.addEventListener(MouseEvent.CLICK, save);
            
            return sh.graphics;
        }
        
        private function preview():void {
            var back:Shape = new Shape();
            back.graphics.beginFill(0xffffff);
            back.graphics.drawRect(0, 0, 38, 38);
            addChild(back);
            
            var bd:BitmapData = new BitmapData(24, 38, true, 0x00000000);
            bd.draw(sh, null, null, null, null, true);
            ba = PNGEncoder.encode(bd);
            addChild(new Bitmap(bd)).x = 7;
            sh.filters = [fl];
        }
        
        private function save(e:MouseEvent):void {
            new FileReference().save(ba, 'icon.png');
        }
        
    }
}