/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tlll
 */

// forked from fakestar0826's BounceInTheBox
package {
    import flash.filters.GlowFilter;
    import flash.events.Event;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="0")]
    public class FlashTest extends Sprite {
        
        private var balls:Array;
        private var numBalls:int = 300;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        private var gravity:Number = 0.2;
        private var floor:Number = 200;
        private var bounce:Number = -0.6;
        
        public function FlashTest() {
            // write as3 code here..
            balls = [];
            for(var i:int = 0;i < numBalls;i++)
            {
                var c:uint = Math.random() * 0xFFFFFF;
                var b:Ball3D = new Ball3D(3, c);
                b.filters = [new GlowFilter(c, 0.5)];
                balls[i] = b;
                b.ypos = -100;
                b.vx = Math.random() * 6 - 3;
                b.vy = Math.random() * 6 - 3;
                b.vz = Math.random() * 6 - 3;
                addChild(b);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            for(var i:int = 0;i < numBalls;i++)
            {
                var b:Ball3D = balls[i];
                move(b);
            }
            sortZ();
        }
        
        private function move(b:Ball3D):void
        {
            var r:Number = b.r;
            b.vy += gravity;
            b.xpos += b.vx;
            b.ypos += b.vy;
            b.zpos += b.vz;
            
            if(b.ypos > floor)
            {
                b.ypos = floor;
                b.vy *= bounce;
            }
            
            if(b.zpos > -fl)
            {
                var scale:Number = fl / (fl + b.zpos);
                b.scaleX = b.scaleY = scale;
                b.x = vpX + b.xpos * scale;
                b.y = vpY + b.ypos * scale;
                b.visible  = true;
            }
            else
            {
                b.visible = false;
            }
        }
        
        private function sortZ():void
        {
            balls.sortOn("zpos", Array.NUMERIC | Array.DESCENDING);
            for(var i:int = 0;i < numBalls;i++)
            {
                var b:Ball3D = balls[i];
                setChildIndex(b, i);
            }

        }

    }
}
import flash.display.Sprite;

class Ball3D extends Sprite
{
    public var r:Number;
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    public var mass:Number = 1;
    
    public function Ball3D(r:Number = 40, c:uint = 0xFF0000)
    {
        this.r = r;
        graphics.beginFill(c);
        graphics.drawCircle(0, 0, r);
        graphics.endFill();
    }

}
