/**
 * Copyright ysformen ( http://wonderfl.net/user/ysformen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tjqv
 */

package {
	import flash.display.Sprite;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	
	public class SprayPaint2 extends Sprite {
		private var canvas:BitmapData;
		private var color:uint;
		private var size:Number = 50;
		private var density:Number = 50;//密度
		
		public function SprayPaint2() {
			init();
		}
		
		private function init():void {
			canvas = new BitmapData(stage.stageWidth,
									stage.stageHeight,
									true, 0x00000000);
			var bmp:Bitmap = new Bitmap(canvas);
			bmp.filters = [new BlurFilter(2,2,3)];
			addChild(bmp);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
		}
		
		private function onMouseDown(event:MouseEvent) {
			color = Math.random() * 0xffffff + 0xff000000;
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onMouseUp(event:MouseEvent) {
			removeEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(event:Event) {
			for (var i:int = 0; i < density; i++) {
				var angle:Number = Math.random() * Math.PI * 2;
				var radius:Number = Math.random() * size;
				var xpos:Number = mouseX + Math.cos(angle) * radius;
				var ypos:Number = mouseY + Math.sin(angle) * radius;
				canvas.setPixel32(xpos, ypos, color);
			}
		}
	}
}