/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tjcv
 */

/*
 * BetweenAS3の基本1(制御)
 * 
 * 参考
 * http://www.be-interactive.org/?itemid=449
 * */
package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Cubic;
	import org.libspark.betweenas3.tweens.ITween;
	
	public class Main extends Sprite
	{
		
		public function Main()
		{
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			mouseUpHandler(null);
		}
		
		private function mouseUpHandler(e:MouseEvent):void
		{
			while (numChildren > 0) {
				removeChildAt(0);
			}
			addNewText(0, 0, "Click to replay");
			
			//◆Step0 イージングをかけてみよう
			addNewText(50, 30, "◆0. tween(ターゲット、終了値、開始値、時間、イージング)");
			var box0:Sprite = addNewBox(50, 50, 0xFF0000);
			//初期化
			var t0:ITween;
			//tween(ターゲット、終了値、開始値、時間、イージング)
			//開始値を指定しない場合は、null
			t0 = BetweenAS3.tween(box0, { x:400, y:100 }, { y:20 }, 3, Cubic.easeOut);
			//開始
			t0.play();
			
			
			//◆Step1 相対値
			addNewText(50, 130, "◆1. 相対的な指定　$x:350");
			var box1:Sprite = addNewBox(50, 150, 0x00FF00);
			var t1:ITween;
			//相対的な指定「x += 350」のような場合は頭に「$」をつけて「$x:350」
			t1 = BetweenAS3.tween(box1, { $x:350, y:200 }, null, 3, Cubic.easeOut);
			t1.play();
			
			
			//◆Step2 途中から
			addNewText(50, 230, "◆2. 途中(0.7秒目)から開始　t2.gotoAndPlay(0.7)");
			var box2:Sprite = addNewBox(50, 250, 0x0000FF);
			var t2:ITween;
			t2 = BetweenAS3.tween(box2, { x:400, y:300 }, null, 3, Cubic.easeOut);
			//0.7秒目から開始
			t2.gotoAndPlay(0.7);
			
			
			//◆Step3 ディレイ
			addNewText(50, 330, "◆3. ディレイ(1.5秒間)　t3 = BetweenAS3.delay(t3,1.5)");
			var box3:Sprite = addNewBox(50, 350, 0x000000);
			var t3:ITween;
			t3 = BetweenAS3.tween(box3, { x:400, y:400 }, null, 3, Cubic.easeOut);
			//1.5秒間のディレイ
			t3 = BetweenAS3.delay(t3, 1.5);
			t3.play();
		}
		
		private function addNewBox(x:Number, y:Number, c:int):Sprite
		{
			var sp:Sprite = new Sprite();
			sp.graphics.beginFill(c);
			sp.graphics.drawRect( -10, -10, 20, 20);
			sp.graphics.endFill();
			sp.x = x;
			sp.y = y;
			addChild(sp);
			return sp;
		}
		
		private function addNewText(x:Number, y:Number, txt:String):TextField
		{
			var tf:TextField = new TextField();
			tf.text = txt;
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.x = x;
			tf.y = y;
			addChild(tf);
			return tf;
		}
	}
}
