/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tj8e
 */

package {
    import flash.utils.getTimer;
    import flash.geom.ColorTransform;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var bitmatData:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight,false,0x0)
            addChild(new Bitmap(bitmatData))
            var shape:Shape = new Shape
            var solid:Object = new Object
            solid.verts = new Vector.<Number>
            solid.verts.push(0,1,0,1,0,0,0,0,1,-1,0,0,0,0,-1,0,-1,0)
            solid.indices = new Vector.<int>
            solid.indices.push(0,1,2,0,2,3,0,3,4,0,4,1,5,2,1,5,3,2,5,4,3,5,1,4)
            var drawSolid:Function = function(matrix:Matrix3D,color:uint):void {
                var persVerts:Vector.<Number> = new Vector.<Number>
                var uvtData:Vector.<Number> = new Vector.<Number>
                Utils3D.projectVectors(matrix, solid.verts, persVerts, uvtData)
                persVerts.map(function(item:Number, index:int, vector:Vector.<Number>):void {
                    vector[index] += (index%2==0) ? stage.stageWidth/2 : stage.stageHeight/2
                })
                shape.graphics.lineStyle(0,color)
                shape.graphics.drawTriangles(persVerts, solid.indices, uvtData, 'negative')
            }   
            var spline:Function = function(p:Vector.<Vector3D>, t:Number):Vector3D {
                var point:Vector3D = new Vector3D
                for each(var v:String in ["x","y","z"]){
                    point[v] =  0.5*(
                                (2*p[1][v]) +
                                (-p[0][v] + p[2][v]) * t +
                                (2*p[0][v] - 5*p[1][v] + 4*p[2][v] - p[3][v]) * Math.pow(t,2) +
                                (-p[0][v] + 3*p[1][v]- 3*p[2][v] + p[3][v]) * Math.pow(t,3) )
                }
                return point
            }                          
            var radius:int = 20            
            var rabbits:Vector.<Vector3D> = new Vector.<Vector3D>
            for (var i:int=0; i<6; i++) {
                rabbits.push(new Vector3D(
                    radius*(Math.random()-0.5),
                    radius*(Math.random()-0.5),
                    radius*(Math.random()-0.5)
                ))
            }            
            var dog:Vector3D = new Vector3D
            var axis:Vector3D = new Vector3D(
                Math.random()-0.5,
                Math.random()-0.5,
                Math.random()-0.5
            )
            var pers:PerspectiveProjection = new PerspectiveProjection
            var persMatrix:Matrix3D = pers.toMatrix3D()
            var worldMatrix:Matrix3D = new Matrix3D
            var solidMatrix:Matrix3D = new Matrix3D              
            var split:int = 60
            var count:int = 1
            addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                var colorTransform:ColorTransform = new ColorTransform(0.95,0.95,0.95)
                bitmatData.colorTransform(bitmatData.rect, colorTransform)
                shape.graphics.clear()
                with (worldMatrix) {
                    identity()
                    appendRotation(getTimer()*0.02, axis)
                    appendTranslation(0,0,30)
                    append(persMatrix)                   
                }
                var n:int = rabbits.length
                while (n--) {
                    with (solidMatrix) {
                        identity()
                        appendTranslation(rabbits[n].x,rabbits[n].y,rabbits[n].z)
                        append(worldMatrix)
                    }
                    drawSolid(solidMatrix,0x007000)
                }
                dog = spline(rabbits,count/split)                
                with (solidMatrix) {
                    identity()
                    appendTranslation(dog.x,dog.y,dog.z)
                    append(worldMatrix)
                }
                drawSolid(solidMatrix,0xa00000)
                bitmatData.draw(shape)
                count++
                if (count>split) {
                    rabbits.shift()
                    rabbits.push(new Vector3D(
                        radius*(Math.random()-0.5),
                        radius*(Math.random()-0.5),
                        radius*(Math.random()-0.5)
                    ))                    
                    count=1
                }
            })                 
        }
    }
}
